## Aggregate

Aggregates values for the members' measures.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |zero-one |[Measures].currentMember |



### Return

```
numeric-value
```



### Description

For performance reason, and for dimensions that do not define a many-to-many relation, we advise using the Eval function that is equivalent to the Aggregate function.

Aggregates values for the specified members over the numeric expression. The aggregation operator derives from the measure.

If no numeric-expression was specified the current measure is taken.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value which is the aggregation of the 'member-set' values.

On the example we aggregate the default [Measures] for all the calendar months.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS Aggregate([Time].[Calendar].[Month].members)
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">All sales</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS Sum([Time].[Calendar].[Month].members,[Measures].[Amount])
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
/*specify measure for the aggregate*/
WITH
    MEMBER [Time].[Calendar].[All sales] AS Aggregate( [Time].[Calendar].[Month].members, [Measures].[Amount] )
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate(member-set,numeric-expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value which is the aggregation of member-set values.

On the example we aggregate the sales for all the calendar months.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS Aggregate([Time].[Calendar].[Month].members)
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">All sales</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS Sum([Time].[Calendar].[Month].members,[Measures].[Amount])
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
/*specify measure for the aggregate*/
WITH
    MEMBER [Time].[Calendar].[All sales] AS Aggregate( [Time].[Calendar].[Month].members, [Measures].[Amount] )
SELECT
    [Time].[Calendar].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - SUM aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Performing a SUM aggregation...

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount]), ([Geography].[Geo].[Switzerland],[Measures].[Amount]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>251</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - SUM aggregation, same tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

Aggregation over the same tuple is going to add twice the value. Note, we are adding twice the same fact row which is not the case for 'engine' standard calculations.

In our example, we sum the value of [Spain] two times.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Spain] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount]), ([Geography].[Geo].[Spain],[Measures].[Amount]) } )
SELECT
    {[Geography].[Geo].[Spain+Spain]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Spain</td>
</tr>
<tr>
 <td>6</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Spain * 2] AS ([Geography].[Geo].[Spain],[Measures].[Amount]) * 2
SELECT
    {[Measures].[Spain * 2]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - COUNT aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Performing a COUNT aggregation...

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Count]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Count]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount-Count]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - MIN aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Performing a MIN aggregation...

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Min]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Min]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>1.00€</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount-Min]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - MAX aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Performing a MAX aggregation...

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Max]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Max]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>128.00€</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount-Max]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - AVERAGE (leaves) aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Performing a AVERAGE (leaves) aggregation...

**Query**

```
WITH
    MEMBER [Measures].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-AvgLeaves]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-AvgLeaves]) } )
SELECT
    {[Measures].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>35.857142857142854</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount-AvgLeaves]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - NONE aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-None]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-None]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'none' is not supported (measure or calculated measure/member:[Measures].[Amount-None])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - AVERAGE (children) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-AvgChildren]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-AvgChildren]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'average (children)' is not supported (measure or calculated measure/member:[Measures].[Amount-AvgChildren])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - OPEN aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Open]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Open]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'open' is not supported (measure or calculated measure/member:[Measures].[Amount-Open])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - CLOSE aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Close]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Close]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'close' is not supported (measure or calculated measure/member:[Measures].[Amount-Close])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - OPEN (non-empty) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-OpenNoEmpty]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-OpenNoEmpty]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'open (non-empty)' is not supported (measure or calculated measure/member:[Measures].[Amount-OpenNoEmpty])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - CLOSE (non-empty) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-CloseNoEmpty]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-CloseNoEmpty]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'close (non-empty)' is not supported (measure or calculated measure/member:[Measures].[Amount-CloseNoEmpty])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - DISTINCT COUNT aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Unique]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Unique]) } )
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'distinct count' is not supported (measure or calculated measure/member:[Measures].[Amount-Unique])</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate - NON EMPTY aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
WITH
    MEMBER [Measures].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-NoEmpty]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-NoEmpty]) } )
SELECT
    {[Measures].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain+Switzerland</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_aggregate_type_not_supported)<br>Error Message : Aggregate() : the aggregation 'no-empty' is not supported (measure or calculated measure/member:[Measures].[Amount-NoEmpty])</pre>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate(member-set,invalid-measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the measure is invalid.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS isError( Aggregate([Time].[Calendar].[Month].members,[Measures].[XXX]))
SELECT
    [Time].[Calendar].[All sales] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All sales</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS true
SELECT
    [Time].[Calendar].[All sales] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Aggregate(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the parameter is NULL.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS NULL = Aggregate(NULL)
SELECT
    [Time].[Calendar].[All sales] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All sales</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Time].[Calendar].[All sales] AS true
SELECT
    [Time].[Calendar].[All sales] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Eval](Eval.md)

[Sum](Sum.md)

[Max](Max.md)

[Min](Min.md)

[Avg](Avg.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
