## AddCalculatedMembers

Generates members' set by appending calculated members that are siblings of the members of the specified member set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
set
```



### Description

AddCalculatedMembers can be used to add calculated members to the member sets as generated by those functions. Only calculated members that are siblings of the members sets are appended.

Please note that MDX functions like Children and Members are ignoring calculated members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers(measures-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all [Measures] members including calculated ones (which are siblings).

**Query**

```
WITH
    MEMBER [Measures].[V] AS 42
SELECT
    AddCalculatedMembers( [Measures].Members ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Amount-Min</td>
  <td class="ic3-mdx-result-cell-header">Amount-Max</td>
  <td class="ic3-mdx-result-cell-header">Amount-Count</td>
  <td class="ic3-mdx-result-cell-header">Amount-AvgChildren</td>
  <td class="ic3-mdx-result-cell-header">Amount-None</td>
  <td class="ic3-mdx-result-cell-header">Amount-Open</td>
  <td class="ic3-mdx-result-cell-header">Amount-Close</td>
  <td class="ic3-mdx-result-cell-header">Amount-OpenNoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-CloseNoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-AvgLeaves</td>
  <td class="ic3-mdx-result-cell-header">Amount-NoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-Unique</td>
  <td class="ic3-mdx-result-cell-header">Fx</td>
  <td class="ic3-mdx-result-cell-header">Answer</td>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>1023</td>
 <td>1.00€</td>
 <td>512.00€</td>
 <td>10</td>
 <td>102.3</td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td>512</td>
 <td>102.3</td>
 <td>1</td>
 <td>10</td>
 <td>1.0310000000000001</td>
 <td>42</td>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER [Measures].[V] AS 42
SELECT
   [Measures].Members + { [Measures].[Answer] /* defined at cube level */ , [Measures].[V] } ON 0
FROM
   [Sales]
```


**Assertion : MDX Equals**

```
WITH
   MEMBER [Measures].[V] AS 42
SELECT
   [Measures].AllMembers ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns members-set with all calculated members which are siblings of 'members-set'.

We create a new city in the United States as a calculated member : [Austin]
We create a new city in Spain as a calculated member : [Sevilla]

AddCalculatedMembers to the United States cities adds the calculated member [Austin] as it's a sibling. [Sevilla] is not added as it's not a city of the United States.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[America].[United States].[Austin] AS 1
    MEMBER [Geography].[Geo].[Europe].[Spain].[Sevilla] AS 2
SELECT
    AddCalculatedMembers( { [Geography].[Geo].[America].[United States].Children, [Geography].[Geo].[Europe].[France].[Paris] } ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Los Angeles</td>
  <td class="ic3-mdx-result-cell-header">New York</td>
  <td class="ic3-mdx-result-cell-header">San Francisco</td>
  <td class="ic3-mdx-result-cell-header">Austin</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
</tr>
<tr>
 <td></td>
 <td>768</td>
 <td></td>
 <td>1</td>
 <td>4</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[America].[United States].[Austin] AS 1
SELECT
    { [Geography].[Geo].[America].[United States].Children, [Geography].[Geo].[America].[United States].[Austin], [Geography].[Geo].[Europe].[France].[Paris]  } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers({}|NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if the parameter is NULL or an empty set.

**Query**

```
AddCalculatedMembers({})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
AddCalculatedMembers(NULL)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
AddCalculatedMembers(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AddCalculatedMembers() : argument (0) type mismatch: expected:'member|set(member)', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
AddCalculatedMembers({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AddCalculatedMembers() : argument (0) type mismatch: expected:'member|set(member)', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddCalculatedMembers(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
AddCalculatedMembers("hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AddCalculatedMembers() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[StripCalculatedMembers](StripCalculatedMembers.md)

[AllMembers](AllMembers.md)

[Calculated Members](Calculated%20Members.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
