## icCube Server Architecture

The server can be self deployed on premises and/or in the cloud.

### Overview

The server is made of a single Java process that is typically deployed using a Docker image. It can run on any server
supporting Java 21 and onwards.

This icCube Java process is hosting an HTTP server used for every communication with the server. Multiple instances can
be started
for scalability and redundancy purpose. In production, icCube is typically accessed from behind your own
Web server possibly hosting your own Web application (embedded scenario).

![Overview](./images/architecture.png)

**In-Memory OLAP Server**

At its core, icCube is an in-memory OLAP server. If needed, several parts of the loaded schema data
can be offloaded to disk to minimize the required amount of RAM.

**Data Sources**

The icCube server reads the schema data from a wide range of data sources. These data sources are
accessed once when loading the schema data. Then, no data sources access is required for the icCube server to execute analytical queries.

**Local Files**

IcCube uses the file system for configuration, schema definitions, schema backups, snapshots
and other temporary data.

**Print Server**

The print server is used for exporting Dashboards to PDF and is based on Chromium|Chrome used in headless
mode. The icCube server Docker image is containing an instance of Chromium|Chrome for the sake of simplicity.
Alternatively, an external Docker image containing Chromium|Chrome only can be used as Print Server.

**Embedded**

Please review this [page](../devops/Embedded.md) for a description about embedding the icCube Dashboards
and the Administration interface into your own Web application according to different architectures.

### Next Steps / Quick Links

* The [user guide](user_guide/user_guide.md) section describes in details the server.
* The [DevOps](../devops/DevOps.md) section describes several production use cases.
* The [AnalyticsOps](../analyticsops/AnalyticsOps.md) section describes how to test your analytics.
* The [REST API](api/index.md) section describes the server HTTP/JSON API.
* The [MDX](mdx/index.md) section describes the query language.
* The [Dashboards](../dashboards/Dashboards.md) section describes how to create dashboards.


_