## icCube REST API : Response Format

Unless otherwise specified, the responses are `text/plain` (UTF-8) documents containing a JSON object.

### JSON Reply

The reply is made of a `status` and a `payload` that depends on the actual request being executed.
Refer to each request documentation for detailed information about the payload format. The status
can be either "ok" or "error":

    {
        "version" : "1",
        "status"  : "ok",
        "payload" : { ... }
    }

### JSON Error Reply

The status of the reply is "error" and the payload contains an error `code` and a plain text
`message` that gives more details about the error:

    {
        "version"    : "1",
        "status"     : "error",
        "payload"    : {
            "code"   : "...",
            "message": "..."
        }
    }

_
