## icCube REST API : Request Format

Unless otherwise specified, commands of the REST API are using the following format.

### URL

The REST API URL is:

    /icCube/api

Administration commands are adding the following part to generate the full URL to use:

    /console/admin/CommandName

As an example, the URL to retrieve the list of loaded schemas (request: `LoadedSchemas`)
is defined as following:

    /icCube/api/console/admin/LoadedSchemas

### Parameters

Unless otherwise specified, `GET` or `POST` requests can be used interchangeably.

`GET` requests are passing parameters using URL encoded parameters whereas `POST` methods
are using a JSON object as request entity (type: `application/json`).

    POST http://localhost:8282/icCube/api/console/admin/SchemaInfo
    
    {
        "schemaName" : "Sales"
    }    

### Verbosity

You can control the log verbosity of the request via the `verbosity` parameter. For example,
the following is removing the log when request the status of the server:

    GET http://localhost:8282/icCube/api/console/admin/ServerStatus?verbosity=quiet

Note that you might need to adjust in `log4.xml`, the log levels for the sessions and authorization loggers
to suppress all the logs associated with this request.

### Filter

Several requests that return a JSON table accept a filter parameter. The documentation of each request
is mentioning which table header can be used for filtering (e.g., schema). The filter parameter can be
defined as follows:

    {
        "filter" : "header-name|CONTAINS|filter-value"
    }

For example, to filter the list of schemas of the group "Demo" whose names contain an "S",
use the following (note that CONTAINS is case-insensitive):

    {
        "filter" : "name|CONTAINS|S"
        "filter" : "group|CONTAINS|Demo"
    }

### Tenant (Impersonation)

Several requests accept the `iTenant` parameter to impersonate a given tenant. Available for super administrator
(administrator without any tenant) only. This allows for example, loading a schema for a given tenant.

    {
        "iTenant" : "..."
    }

### Compression

The icCube server is accepting GZIP responses, so you can specify the header: `Accept-Encoding: gzip`.

_