## TidyExecuteMdxScript

Execute an MDX script.

### URL

    /icCube/api/console/mdx/TidyExecuteMdxScript

### Parameters

| Name       | Type      | Cardinality | Default Value |
|------------|-----------|-------------|---------------|
| schemaName | `string`  | one         |               |
| script     | `string`  | one         |               | 
| json       | `boolean` | zero-one    | false         |
| flat       | `boolean` | zero-one    | false         |

### Return (Payload)

    // -- An error or a set of MDX results ----------------------------
    
    ScriptResult {
    
        requestId: string;
    
        error?   : MdxError;
        results? : MdxResult[];
    
    }
    
    // -- Error -------------------------------------------------------
    
    MdxError {
    
        errorCode         : string;
        errorMessage      : string;
    
        range?            : MdxRange;
        javaNativeErrors? : JavaNativeErrors;
    
    }
    
    MdxRange {
    
        regions : MdxRangeRegion[];
    
    }
    
    MdxRangeRegion {
    
        from       : number /* 0-based */;
        to         : number /* 0-based: inclusive */;
        lineNumber : number /* 1-based */;
    
    }
    
    JavaNativeErrors {
    
        sourceCode : string;
        errors     : JavaNativeError[];
    }
    
    JavaNativeError {
    
        lineNumber    : number;
    
        startPosition : number;
        endPosition   : number;
    
        message       : String;
    
    }
    
    // -- MDX Result --------------------------------------------------

    DataSetType = MdxSelectTidyTable | MdxDrillthroughTidyTable | MdxInfoTidyTable | FlatTidyTable;

    MdxResult {
    
        error?   : MdxError;
        dataSet? : DataSetType;
    
    }
    
    TidyTable<COLUMN extends TidyTableColumn> {
    
        classID                : string;
    
        columns                : COLUMN[];
    
        rowCount               : number;
        tidyMaxRowCount        : number;
        tidyMaxRowCountReached : boolean; 
    
        // Post processing support : contains all the ADD_TO_RESULT steps computed during the post-processing.

        steps?  : Record<number, DataSetType>;
    }
    
    TidyTableColumn {
    
        classID    : string;
    
        name       : string;
        caption    : string;
    
        type       : TidyTableColumnValueType:
        typeParam? : TidyTableColumnValueType:
    }
    
    TidyTableColumnValueType = "UNKNOWN" | "NULL" | "CHARACTER" | "NUMERIC" | "LOGICAL" | "DATETIME" | "LIST" | "MIXED";
    
    // Returned by regular MDX select statement.
    
    MdxSelectTidyTable extends TidyTable<MdxSelectTidyTableColumn> {
    
        classID : "MDX_TABLE";
    
        query   : Record<string,any> /* a bunch of properties */;
    
        axes    : MdxSelectTidyTableAxis[];
        infos   : MdxSelectTidyTableMemberInfo[][] /* [axis-index][hierarchy-index] */;
    }
    
    MdxSelectTidyTableColumn extends TidyTableColumn {
    
        axis : MdxSelectTidyTableColumnAxisInfo;
    
    }
    
    MdxSelectTidyTableColumnAxisInfo {
    
        axis          : number;
    
        hierarchyIdx  : number;
        hierarchyInfo : MdxSelectTidyTableColumnHierarchyInfo;
    
        // Available when all the members of the axis belongs to this level.
        levelInfo?    : MdxSelectTidyTableColumnLevelInfo;
    
    }
    
    MdxSelectTidyTableColumnHierarchyInfo {
    
        caption        : string;
        name           : string;
        uniqueName     : string;
    
        type?          : "date" | "time";
        defaultMember? : MdxSelectTidyTableColumnMemberInfo;
    
    }
    
    MdxSelectTidyTableColumnLevelInfo {
    
        caption        : string;
        name           : string;
        uniqueName     : string;
    
        type?          : "date" | "time";
        subType?       : "YEAR" | "HALF_YEAR" | "QUARTER" | "MONTH" | "WEEK" | "DAY" | "DAY_MONTH" | "DAY_YEAR"
                            | "HOUR" | "HALF_HOUR" | "QUARTER_HOUR" | "MINUTE" | "SECOND" ;
    
    }
    
    MdxSelectTidyTableCellsColumn extends MdxSelectTidyTableColumn {
    
        classID          : "MDX_CELLS";
    
        tupleIdx         : number /* position in the axis 0 */;
        fs?              : string /* FORMAT_STRING of the corresponding member in the axis 0 */;
    
        values           : (any | null)[];
        valuesN?         : ValuesNaN;   // json=true only

        formattedValues? : (string | null)[];
        errors?          : (any | undefined)[];
    
    }
    
    MdxSelectTidyTableMembersColumn extends MdxSelectTidyTableColumn {
    
        classID : "MDX_MEMBERS";
    
        // Note that values are from the table.info[axis.axis][axis.hierarchyIdx].
    
    }
    
    MdxSelectTidyTableAxis {
    
        asColumns      : boolean /* the axis has been converted to tidy table columns (i.e., axis 0) */;
        axis           : number;
        hierarchyCount : number;
        length         : number;
        hasNonEmpty    : boolean;
    
        // Each MDX axis is converted into one or more members columns; each of these columns is using the same content.
        // The tuple index for each row (a tuple is repeated because of other MDX axes creating a crossjoin).
        //
        // Aka. row-index-to-tuple-index.
    
        content: number[];
    
    }
    
    // Actual content of the MDX axes.
    
    MdxSelectTidyTableMemberInfo {
    
        axis               : number;
        hierarchyIdx       : number;
    
        hasNonEmpty        : boolean;
    
        // The position of the member in the xyz (e.g., names) arrays for each index of the tuples in the axis.
        //
        // Aka. tuple-index-to-member-index.
        //
        // For example, retrieving the caption of the member for a given row index within a members column:
        //
        //      tupleIdx  = table.axes[column.axis.axis].content[rowIndex];
        //
        //      members   = table.infos[column.axis.axis][column.axis.hierarchyIdx];
        //      memberIdx = members.memberInfoIndices[tupleIdx];
        //
        //      caption   = column.captions[memberIdx];
    
        memberInfoIndices  : number[];
    
        // json=true : all members are from the same level and contains the all member, this information overrides 
        //             every compressed array : e.g., uniqueNames, childrenCounts, etc...
        allMember? : AllMemberInfo;

        names : string[];

        // json=true : null means same as names : use the names[] field instead.
        captions? : string[];

        // json=true : strings or generator-functions (see below), a single value means same value for all the members,
        //             all-member override.
        uniqueNames   : string[];

        // json=true : a single value means same value for all the members, all-member override.
        parentUniqueNames?   : (string | null)[];
    
        // json=true : a single value means same value for all the members, all-member override.
        childrenCounts : number[];
    
        // json=true : a single value means same value for all the members, all-member override.
        levelCaptions : string[];

        // json=true : a single value means same value for all the members, all-member override.
        levelNames : string[];

        // json=true : a single value means same value for all the members, all-member override.
        levelUniqueNames : string[];

        // json=true : a single value means same value for all the members, all-member override.
        levelDepths : number[];

        // json=true : a single value means same value for all the members, all-member override.
        levelDepthsR : number[];
    
        keys? : (any | null)[];

        // json=true : true means the keys are the same as the names : use the names[] field instead.
        keysN? : boolean;

        alls? : (boolean | null)[];
    
        // json=true : a single value means same value for all the members, all-member override.
        formatStrings? : (string | null)[];

        colors?  : (string | null)[];
        ic3iso2? : (string | null)[];
        ic3lat?  : (number | null)[];
        ic3long? : (number | null)[];
    
        // DIMENSION PROPERTIES
    
        dpNames?   : string[];
        dpTypes?   : Record<string, TidyTableColumnValueType>;
        dpValues?  : Record<string, (any | null)[]>;
        dpValuesN? : Record<string, ValuesNaN>;
    
    }
     
    // Returned by MDX DRILLTHROUGH statement.
    
    MdxDrillthroughTidyTable extends TidyTable<MdxDrillthroughTidyTableColumn> {
    
        classID : "MDX_DRILLTHROUGH_TABLE";
    
    }
    
    MdxDrillthroughTidyTableColumn extends TidyTableColumn {
    
        classID  : "MDX_DRILLTHROUGH_DATA";

        values   : any[];
        valuesN? : ValuesNaN;   // json=true only
    
    }
    
    // Returned by all other statement (e.g., CREATE SET...).
    // Contains a single row table with three columns: type(string), details(string), on-error status(boolean).
    
    MdxInfoTidyTable extends TidyTable<MdxInfoTidyTableColumn> {
    
        classID : "MDX_INFO_TABLE";
    
    }
    
    MdxInfoTidyTableColumn extends TidyTableColumn {
    
        classID  : "MDX_INFO_DATA";

        values   : any[];
        valuesN? : ValuesNaN;   // json=true only
    
    }

    // Returned by post-processing statement.
    
    FlatTidyTable extends TidyTable<FlatTidyTableColumn> {
    
        classID : "TIDY_TABLE";
    
    }
    
    FlatTidyTableColumn extends TidyTableColumn {
    
        classID  : "TIDY_DATA";
        
        values   : any[];
        valuesN? : ValuesNaN;   // json=true only
    
    }

    AllMemberInfo {

        // the position overridden in the de-compressed array (e.g., uniqueNames)  
        index         : number;
   
        name          : string;
        caption       : string;
        uniqueName    : string;
        childrenCount : number;
        key?          : any;
        formatString? : string;

        level : {

            levelCaption    : string;
            levelName       : string;
            levelUniqueName : string;
            levelDepth      : number;
            levelDepthR     : number;
            
        }

    }

    ValuesNaN {

        // The positions in the values[] of the NaN values.
        NaN? : [number];

        // The positions in the values[] of the +Infinity values.
        InfinityP? : [number];

        // The positions in the values[] of the -Infinity values.
        InfinityN? : [number];

    }

    // Unique Name Generators : a number indicating how to create the unique name :
    //
    //          0 : LEVEL_KEY        level unique name  + member's key
    //          1 : LEVEL_NAME       level unique name  + member's name
    //          2 : PARENT_KEY       parent unique name + member's key
    //          3 : PARENT_NAME      parent unique name + member's name
    //
    //      e.g., [Article].[Article].[Article].&[42]     LEVEL_KEY
    //            ^                               ^
    //            level unique name               member's key
    //
    //      e.g., [Article].[Article].[Article].[Bike]    LEVEL_NAME
    //            ^                              ^
    //            level unique name              member's name
    //
    //            do not forget to escape closing ']' in the member's name by doubling them.

### Description

This request execute an MDX script against a loaded schema.

Note that since icCube 8.6.2, the execution of the script is possibly using the MDX result cache 
(see the `resultCacheConfiguration` section in the configuration file `icCube.xml`).

The script can contain one or more statements. A statement can be one of the following:

- an MDX select statement
- an MDX drillthrough statement
- a `create` or `drop` command statement

So on top of regular MDX statements (i.e., `select from ...`) a script can contain any statement
(e.g., `create/drop member ...`) and ic3 commands ([www](../user_guide/using/exec_commands.md)).

On completion, the response contains either an error (e.g., more likely because the script could not be
compiled/executed)  or a list of results (one result for each statement of the script). Each result might
be in turn either an error (e.g., an MDX select could not be performed because of an unknown member) or a
dataset.

Note that multidimensional MDX results are converted to [tidy tables](../../dashboards/tidyTable/TidyTable.md).

The MDX axis 0 is always converted into tidy table columns unless the query is a single axis query and is
retrieving the `cell_ordinal` only. In that case, a tidy table with a single column (made of the axis 0 content)
is being returned. For example, the following query is returning the list of countries in a single column:

    SELECT
        [Geography].[Geography].[Country] ON 0
    FROM [Sales
    CELL PROPERTIES CELL_ORDINAL

The format of the tidy table columns representing the members (vs cells) values is a bit complex because
of potential cross-joins. The following query is showing a way to extract the required member information
as a cell column. In this example, the names of the continent are retrieved as the first cell column:

    WITH
        MEMBER [Measures].[Name] AS [Geography].[Geography].currentMember.name
    SELECT
        { [Measures].[Name], [Measures].[#Articles] } ON 0
        [Geography].[Geography].[Continent] ON 1
    FROM [Sales]

Please refer to Return (Payload) section above for a detailed description of the response.
This description use a Typescript like notation.

### Response Format

Unless the `json` parameter has been set to `true`, the response can contain `NaN`, `+Infinity`,
`-Infinity` values. So, please use a JSON5 parser or the (Javascript) `eval()` method to extract the result.

When the `json` parameter is set to `true`, the response is a valid JSON document and therefore cannot contain
`NaN`, `+Infinity`, `-Infinity` values. Instead, an additional `ValuesNaN` field has been added to complete the
`values[]`. Please check the Return (payload) section above for more details.

When the `json` parameter is set to `true`, MDX tidy tables are using a new _compressed_ format to minimize
the MDX information sent over the network in the `MdxSelectTidyTableMemberInfo` arrays. Please check the Return
(payload) section above for more details.

The `flat` parameter allows for serializing the result of a regular MDX `SELECT` statement as a `FlatTidyTable`
for the sake of simplicity :

- members are serialized using their caption,
- cells are serialized using their error (as string) or their actual value.

### See Also

[MDX Post Processing](../post_processing/index.md)

_