/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.searchconsole.v1.SearchConsole;
import com.google.api.services.searchconsole.v1.SearchConsoleScopes;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.authorization.GoogleCredentialServiceAccountBuilder;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;

import java.io.IOException;
import java.security.GeneralSecurityException;

public class OlapBuilderGoogleSearchConsoleConnection extends OlapBuilderAbstractConnection<OlapBuilderGoogleSearchConsole4DataSource>
{
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();

    public static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();

    public static final String APPLICATION_NAME = "icCube Local App";

    public OlapBuilderGoogleSearchConsoleConnection(OlapBuilderGoogleSearchConsole4DataSource dataSource)
    {
        super(dataSource);
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException
    {
        // do not call createDataClient() , one use only
    }

    private SearchConsole createDataClient(OlapRuntimeContext context)
    {
        try
        {
            GoogleCredentialServiceAccountBuilder builder = new GoogleCredentialServiceAccountBuilder(dataSource.getServiceAccountPrivateKey());

            GoogleCredentials credentials = builder.authorize(context, SearchConsoleScopes.WEBMASTERS_READONLY);

            SearchConsole service = new SearchConsole.Builder(HTTP_TRANSPORT, JSON_FACTORY, new HttpCredentialsAdapter(credentials))
                    .setApplicationName(APPLICATION_NAME)
                    .build();

            return service;

        }
        catch (IOException | GeneralSecurityException e)
        {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, e);
        }
    }

    @Override
    protected void onClose()
    {
    }

    public SearchConsole getSearchConsole(OlapRuntimeContext context)
    {
        return createDataClient(context);
    }

}
