/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.ga4.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateXmlAdapter;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

import java.io.File;
import java.util.Arrays;
import java.util.List;

@XmlRootElement(name = "GA4DataSource")
public class OlapBuilderGoogleAnalytics4DataSource extends OlapBuilderBaseDataSource<OlapBuilderGoogleAnalytics4Connection>
{
    public static final CdProperty PROPERTY_ID = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataSource.class, "propertyId", false);

    public static final CdProperty SERVICE_ACCOUNT_PRIVATE_KEY = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataSource.class, "serviceAccountPrivateKey", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return File.class;
        }

    };

    public static final CdProperty START_DATE = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataSource.class, "startDate", false);

    public static final CdProperty END_DATE = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataSource.class, "endDate", false);

    public static final CdProperty PAGE_SIZE = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataSource.class, "pageSize", false);

    final static List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(
            OlapBuilderGoogleAnalytics4DataTable.class
    );

    private static int DEFAULT_PAGE_SIZE = 25000;

    @XmlAttribute(required = true)
    private String propertyId;

    @XmlAttribute(required = true)
    private String serviceAccountPrivateKey;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate startDate;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate endDate;

    @XmlAttribute(required = false)
    private Integer pageSize;

    public OlapBuilderGoogleAnalytics4DataSource()
    {
        super();
    }

    @Override
    protected String getReportDataSourceType()
    {
        return "googleAnalytics v4";
    }

    @Override
    protected String getReportDataSourceTypeCaption()
    {
        return "Google Analytics v4";
    }

    @Override
    public boolean isDiscoverTablesSupported()
    {
        return false;
    }

    /**
     * @return a possibly null list of table that can be created by this datasource.
     */
    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes()
    {
        return CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderGoogleAnalytics4Connection createConnection(OlapRuntimeContext context, boolean forceRefresh)
    {
        return new OlapBuilderGoogleAnalytics4Connection(this);
    }

    @Override
    public OlapBuilderGoogleAnalytics4DataTable createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType)
    {
        return new OlapBuilderGoogleAnalytics4DataTable();
    }

    @Override
    public UxBuilderDataSourceTypeGroupId getUxGroupId()
    {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupGoogle;
    }

    public String getPropertyId()
    {
        return propertyId;
    }

    public void setPropertyId(String propertyId)
    {
        this.propertyId = propertyId;
    }

    public String getServiceAccountPrivateKey()
    {
        return serviceAccountPrivateKey;
    }

    @Nullable
    public LocalDate getStartDate()
    {
        return startDate;
    }

    @Nullable
    public LocalDate getEndDate()
    {
        return endDate;
    }

    public int getPageSize()
    {
        return pageSize == null ? DEFAULT_PAGE_SIZE : pageSize;
    }
}
