/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.errors;

import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import org.jetbrains.annotations.PropertyKey;

public class OlapGoogleApiError extends OlapBuilderErrorCode
{
    public static final OlapBuilderErrorCode BIGQUERY_PROJECTID_MANDATORY = new OlapGoogleApiError("BQ_PROJECT_ID_MANDATORY");

    public static final OlapBuilderErrorCode BIGQUERY_TIMEOUT = new OlapGoogleApiError("BQ_TIMEOUT");

    public static final OlapBuilderErrorCode JSON_API_ERROR = new OlapGoogleApiError("JSON_API_ERROR");

    public static final OlapBuilderErrorCode TOKEN_ERROR = new OlapGoogleApiError("TOKEN_ERROR");

    public static final OlapBuilderErrorCode GOOGLE_OAUTH_IO_ERROR = new OlapGoogleApiError("GOOGLE_OAUTH_IO_ERROR");

    public static final OlapBuilderErrorCode GOOGLE_DRIVE_MISSING_FILE_NAME = new OlapGoogleApiError("GOOGLE_DRIVE_MISSING_FILE_NAME");

    public static final OlapBuilderErrorCode GA_INVALID_GADATE_TYPE = new OlapGoogleApiError("GA_INVALID_GADATE_TYPE");

    public static final OlapBuilderErrorCode GA_INTERNAL_ERROR = new OlapGoogleApiError("GA_INTERNAL_ERROR");

    public static final OlapBuilderErrorCode GA_WEBSITE_NOT_FOUND = new OlapGoogleApiError("GA_WEBSITE_NOT_FOUND");

    private static final long serialVersionUID = 2507086350862577567L;

    public OlapGoogleApiError(@PropertyKey(resourceBundle = "crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError") String value)
    {
        super(value);
    }

    public static OlapBuilderErrorException error(String objectType, String tableName, GoogleJsonResponseException ex)
    {
        final GoogleJsonError jsonError = ex.getDetails();
        return new OlapBuilderErrorException(true, OlapGoogleApiError.JSON_API_ERROR, objectType, tableName, jsonError.getMessage(), jsonError.getCode());
    }

    public static OlapBuilderErrorException error(String objectType, String tableName, TokenResponseException ex)
    {
        final TokenErrorResponse tokenError = ex.getDetails();
        String description = tokenError == null || tokenError.getErrorDescription() == null ? "" : (" - " + tokenError.getErrorDescription());
        return new OlapBuilderErrorException(true, OlapGoogleApiError.TOKEN_ERROR, objectType, tableName, tokenError == null ? ex.getMessage() : tokenError.getError(), description);
    }
}