/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.util.List;

@XmlRootElement(name = "goCsvDT")
public class OlapBuilderGoogleCsvDataTable extends OlapBuilderBaseDataTable<OlapBuilderGoogleCsvConnection>
{
    public static final CdProperty TRIM_STRINGS = new CdReadWriteProperty(OlapBuilderGoogleCsvDataTable.class, "trimStrings");

    @XmlAttribute(required = false)
    private boolean trimStrings;

    public OlapBuilderGoogleCsvDataTable()
    {
    }

    public OlapBuilderGoogleCsvDataTable(String tableName)
    {
        super(tableName);
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "Google Drive CSV File";
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderGoogleCsvConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount)
    {
        throw new RuntimeException("internal error : not supported yet");
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleCsvConnection openedConnection, OlapBuilderErrorManager errorManager)
    {
        return null;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderGoogleCsvConnection connection, OlapBuilderErrorManager errorManager)
    {
        return null;
    }

}
