/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.List;

@XmlRootElement(name = "goCsvDS")
public class OlapBuilderGoogleCsvDataSource extends OlapBuilderGoogleDriveDataSource<OlapBuilderGoogleCsvConnection>
{
    public OlapBuilderGoogleCsvDataSource()
    {
    }

    @Override
    protected String getReportDataSourceType()
    {
        return "googleCsv";
    }

    @Override
    protected String getReportDataSourceTypeCaption()
    {
        return "Google CSV";
    }

    @Override
    public boolean isDiscoverTablesSupported()
    {
        return true;
    }

    /**
     * @return a possibly null list of table that can be created by this datasource.
     */
    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes()
    {
        return null /* cannot create any table */;
    }

    @Override
    public OlapBuilderGoogleCsvDataTable createEmptyDiscoverTable(String tableName)
    {
        return new OlapBuilderGoogleCsvDataTable(tableName);
    }

    @Override
    public List<String> discoverAllTablesNames(OlapBuilderGoogleCsvConnection connection, boolean filterSystemSchemas, final @Nullable String filter)
    {
        try
        {
            return connection.getFileNames(filter);
        }
        catch (IOException e)
        {
            throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_OAUTH_IO_ERROR, e.getLocalizedMessage());
        }
    }

    @Override
    public OlapBuilderGoogleCsvConnection createConnection(OlapRuntimeContext context, boolean forceRefresh)
    {
        return new OlapBuilderGoogleCsvConnection(this);
    }

    @Override
    protected UxBuilderDataSourceType createUxType()
    {
        return new UxBuilderDataSourceType(getTypeId(), getUxTypeImage(), () -> new OlapBuilderGoogleCsvDataSourceUxWizard(this, getTypeId()));
    }
}
