/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderUxModel;
import org.jetbrains.annotations.NotNull;

import java.net.URI;

public class OlapBuilderWizardWebTokenUxModel implements OlapBuilderUxModel
{
    public static final CdProperty URL = new CdReadWriteProperty(OlapBuilderWizardWebTokenUxModel.class, "url")
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return URI.class;
        }
    };

    public static final CdProperty TOKEN = new CdReadWriteProperty(OlapBuilderWizardWebTokenUxModel.class, "token");

    public static final CdProperty UID = new CdReadWriteProperty(OlapBuilderWizardWebTokenUxModel.class, "uid", true, false);

    private String url;

    private String uid;

    private String token;

    public OlapBuilderWizardWebTokenUxModel()
    {
    }

    public OlapBuilderWizardWebTokenUxModel(String url, @NotNull String uid)
    {
        this.url = url;
        this.uid = uid;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getUid()
    {
        return uid;
    }

    public void setUid(String uid)
    {
        this.uid = uid;
    }

    public String getToken()
    {
        return token;
    }

}
