/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.googleapi.authorization.GoogleCredentialServiceAccountBuilder;
import crazydev.iccube.builder.googleapi.authorization.OlapBuilderGoogleCredentialBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import org.jetbrains.annotations.Nullable;

import java.io.File;

public abstract class OlapBuilderGoogleApiDataSource<CONNECTION extends IOlapBuilderConnection> extends OlapBuilderBaseDataSource<CONNECTION>
{
    public static final String CREDENTIALS = "group.credentials";

    public static final CdProperty SERVICE_ACCOUNT_PRIVATE_KEY = new CdReadWriteProperty(OlapBuilderGoogleApiDataSource.class, "serviceAccountPrivateKey", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return File.class;
        }

        @Override
        public String getGroupName()
        {
            return CREDENTIALS;
        }
    };

    static final String GOOGLE_OAUTH2_PROPERTY = "google.oauth2.secretFile";

    // file name with the private key for the google service account
    @XmlAttribute()
    protected String serviceAccountPrivateKey;

    public OlapBuilderGoogleApiDataSource(String serviceAccountPrivateKey)
    {
        this.serviceAccountPrivateKey = serviceAccountPrivateKey;
    }

    public OlapBuilderGoogleApiDataSource()
    {
    }

    @Override
    public UxBuilderDataSourceTypeGroupId getUxGroupId()
    {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupGoogle;
    }

    public String getServiceAccountPrivateKey()
    {
        return serviceAccountPrivateKey;
    }

    @Nullable
    public Integer getTimeout()
    {
        return null;
    }

    public OlapBuilderGoogleCredentialBuilder getCredentialBuilder(OlapRuntimeContext context)
    {

        return new GoogleCredentialServiceAccountBuilder(serviceAccountPrivateKey);

    }

    public void setServiceAccount(OlapBuilderGoogleDataSourceUxWizard.ServiceAccountProperties props)
    {
        serviceAccountPrivateKey = props.serviceAccountPrivateKey;
    }
}
