/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

public class StorageSample
{
//    public static void main(String... args) throws Exception
//    {
//        // Sets your Google Cloud Platform project ID.
//        // String projectId = "YOUR_PROJECT_ID";
//        String projectId = args[0];
//        Integer snapshotMillis = null;
//        if (args.length > 1)
//        {
//            snapshotMillis = Integer.parseInt(args[1]);
//        }
//
//        try (BigQueryReadClient client = BigQueryReadClient.create())
//        {
//            String parent = String.format("projects/%s", projectId);
//
//            // This example uses baby name data from the public datasets.
//            String srcTable =
//                    String.format(
//                            "projects/%s/datasets/%s/tables/%s",
//                            "bigquery-public-data", "usa_names", "usa_1910_current");
//
//            // We specify the columns to be projected by adding them to the selected fields,
//            // and set a simple filter to restrict which rows are transmitted.
//            TableReadOptions options =
//                    TableReadOptions.newBuilder()
//                            .addSelectedFields("name")
//                            .addSelectedFields("number")
//                            .addSelectedFields("state")
//                            .setRowRestriction("state = \"WA\"")
//                            .build();
//
//            // Start specifying the read session we want created.
//            ReadSession.Builder sessionBuilder =
//                    ReadSession.newBuilder()
//                            .setTable(srcTable)
//                            // This API can also deliver data serialized in Apache Avro format.
//                            // This example leverages Apache Avro.
//                            .setDataFormat(DataFormat.AVRO)
//                            .setReadOptions(options);
//
//            // Optionally specify the snapshot time.  When unspecified, snapshot time is "now".
//            if (snapshotMillis != null)
//            {
//                Timestamp t =
//                        Timestamp.newBuilder()
//                                .setSeconds(snapshotMillis / 1000)
//                                .setNanos((snapshotMillis % 1000) * 1000000)
//                                .build();
//                TableModifiers modifiers = TableModifiers.newBuilder().setSnapshotTime(t).build();
//                sessionBuilder.setTableModifiers(modifiers);
//            }
//
//            // Begin building the session creation request.
//            CreateReadSessionRequest.Builder builder =
//                    CreateReadSessionRequest.newBuilder()
//                            .setParent(parent)
//                            .setReadSession(sessionBuilder)
//                            .setMaxStreamCount(1);
//
//            // Request the session creation.
//            ReadSession session = client.createReadSession(builder.build());
//
//            SimpleRowReader reader =
//                    new SimpleRowReader(new Schema.Parser().parse(session.getAvroSchema().getSchema()));
//
//            // Assert that there are streams available in the session.  An empty table may not have
//            // data available.  If no sessions are available for an anonymous (cached) table, consider
//            // writing results of a query to a named table rather than consuming cached results directly.
//            Preconditions.checkState(session.getStreamsCount() > 0);
//
//            // Use the first stream to perform reading.
//            String streamName = session.getStreams(0).getName();
//
//            ReadRowsRequest readRowsRequest =
//                    ReadRowsRequest.newBuilder().setReadStream(streamName).build();
//
//            // Process each block of rows as they arrive and decode using our simple row reader.
//            ServerStream<ReadRowsResponse> stream = client.readRowsCallable().call(readRowsRequest);
//            for (ReadRowsResponse response : stream)
//            {
//                Preconditions.checkState(response.hasAvroRows());
//                reader.processRows(response.getAvroRows());
//            }
//        }
//    }
//
//    /*
//     * SimpleRowReader handles deserialization of the Avro-encoded row blocks transmitted
//     * from the storage API using a generic datum decoder.
//     */
//    private static class SimpleRowReader
//    {
//        private final DatumReader<GenericRecord> datumReader;
//
//        // Decoder object will be reused to avoid re-allocation and too much garbage collection.
//        private BinaryDecoder decoder = null;
//
//        // GenericRecord object will be reused.
//        private GenericRecord row = null;
//
//        public SimpleRowReader(Schema schema)
//        {
//            Preconditions.checkNotNull(schema);
//            datumReader = new GenericDatumReader<>(schema);
//        }
//
//        /**
//         * Sample method for processing AVRO rows which only validates decoding.
//         *
//         * @param avroRows object returned from the ReadRowsResponse.
//         */
//        public void processRows(AvroRows avroRows) throws IOException
//        {
//            decoder =
//                    DecoderFactory.get()
//                            .binaryDecoder(avroRows.getSerializedBinaryRows().toByteArray(), decoder);
//
//            while (!decoder.isEnd())
//            {
//                // Reusing object row
//                row = datumReader.read(row, decoder);
//                System.out.println(row.toString());
//            }
//        }
//    }
}