/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.Iterator;

public class OlapBuilderGoogleBigQueryStorageStream
{
    private final OlapBuilderGoogleBigQueryStorageStreams streams;

    private final String streamName;

    private final Iterator<ReadRowsResponse> stream;

    private OlapBuilderGoogleBigQueryStorageStreamResponse currentResponse;

    private int rowCount;

    private int createdDecoderCount;

    private int closedDecoderCount;

    public OlapBuilderGoogleBigQueryStorageStream(OlapBuilderGoogleBigQueryStorageStreams streams, String streamName, ServerStream<ReadRowsResponse> stream)
            throws IOException
    {
        OlapLoggers.BUILDER_GOOGLE.debug("[big-query-storage] table [" + streams.getTableNameQ() + "] session stream: " + streamName);

        this.streams = streams;
        this.streams.incrementCreatedStreamCount();

        this.streamName = streamName;
        this.stream = stream.iterator();

        if (this.stream.hasNext())
        {
            this.currentResponse = new OlapBuilderGoogleBigQueryStorageStreamResponse(
                    this, streams.getSchema(), this.stream.next()
            );
        }
        else
        {
            this.currentResponse = null;
        }
    }

    public void incrementCreatedDecoderCount()
    {
        createdDecoderCount++;
    }

    public void incrementClosedDecoderCount()
    {
        closedDecoderCount++;
    }

    @Nullable
    public IOlapBuilderTableRow nextRow()
            throws IOException
    {
        while (currentResponse != null)
        {
            final IOlapBuilderTableRow row = currentResponse.nextRow();

            if (row != null)
            {
                rowCount++;

                return row;
            }

            if (stream.hasNext())
            {
                currentResponse.close();
                currentResponse = new OlapBuilderGoogleBigQueryStorageStreamResponse(
                        this, streams.getSchema(), stream.next()
                );
            }
            else
            {
                currentResponse.close();
                currentResponse = null;
            }
        }

        return null;
    }

    public void close()
    {
        streams.incrementClosedStreamCount();

        if (currentResponse != null)
        {
            currentResponse.close();
            currentResponse = null;
        }

        OlapLoggers.BUILDER_GOOGLE.debug("[big-query-storage] table [" + streams.getTableNameQ() + "] closed session stream: " + streamName + " [rows:" + rowCount + "] [" + createdDecoderCount + "][" + closedDecoderCount + "]");
    }

}
