/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleDataSourceUxWizard;
import crazydev.iccube.builder.googleapi.common.OlapBuilderWizardWebTokenUxModel;

class OlapBuilderGoogleBigQueryDataSourceUxWizard extends OlapBuilderGoogleDataSourceUxWizard<OlapBuilderGoogleBigqueryDataSource, OlapBuilderGoogleBigQueryUxModel, OlapBuilderWizardWebTokenUxModel>
{
    OlapBuilderGoogleBigQueryDataSourceUxWizard(OlapBuilderGoogleBigqueryDataSource ds, String dataSourceTypeId)
    {
        super(dataSourceTypeId, createUxCreateWizardSteps(), ds);
    }

    @Override
    public OlapBuilderGoogleBigQueryUxModel createWebTokenModel()
    {
        return new OlapBuilderGoogleBigQueryUxModel();
    }

    @Override
    public OlapBuilderGoogleApiDataSource getDataSourceFromUIForWebtoken()
    {
        final OlapBuilderGoogleBigQueryUxModel websiteModel = getStepModelFor(OlapBuilderGoogleBigQueryUxModel.class);

        final OlapBuilderGoogleBigqueryDataSource dataSource = new OlapBuilderGoogleBigqueryDataSource();
        if (websiteModel != null)
        {
            dataSource.setTokenSubscope(websiteModel.getTokenSubscope());
        }
        return dataSource;
    }

    @Override
    protected Object createScopeModelForService()
    {
        return new OlapBuilderGoogleBigQueryDSUxModel();
    }

    @Override
    protected OlapBuilderGoogleApiDataSource getDataSourceFromUIForServiceAccount()
    {
        final OlapBuilderGoogleBigQueryDSUxModel model = getStepModelFor(OlapBuilderGoogleBigQueryDSUxModel.class);

        final OlapBuilderGoogleBigqueryDataSource dataSource = new OlapBuilderGoogleBigqueryDataSource();
        dataSource.setProjectId(model.getProjectId());
        return dataSource;
    }

}
