/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import org.apache.commons.lang3.StringUtils;

public class OlapBuilderBigQueryStatementDataTableValidator extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderGoogleBigqueryConnection, IOlapBuilderDataSource<OlapBuilderGoogleBigqueryConnection>>
{
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderGoogleBigqueryConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderGoogleBigqueryConnection> dataTable)
    {
        final OlapBuilderGoogleBigqueryDataSource ds = (OlapBuilderGoogleBigqueryDataSource) dataTable.getDataSource();

        if (StringUtils.isBlank(ds.getProjectId()))
        {
            context.addError(OlapBuilderGoogleBigqueryDataSource.PROJECT, OlapGoogleApiError.BIGQUERY_PROJECTID_MANDATORY, OlapBuilderGoogleBigqueryDataSource.PROJECT.getName());
        }
        else
        {
            super.doValidate(context, dataSource, dataTable);
        }

    }
}
