/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.mapreduce;

import com.mongodb.DBObject;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

@XmlRootElement(name = "mongoDB-map-reduce")
public class OlapBuilderMongoDbMapReduceDataTable extends OlapBuilderMongoDbDataTable
{
    public static final CdProperty MAP_REDUCE = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "mapReduceCommands", true)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty MAP_REDUCE_INCR_LOAD = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "mapReduceCommandsIncrLoad", true)
    {
        @Override
        public boolean isForIncrLoad()
        {
            return true;
        }

        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty SKIP = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "skip", false);

    public static final CdProperty LIMIT = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "limit", false);

    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "batchSize", false);

    @XmlElement(name = "mapReduceCommands", required = true)
    private String mapReduceCommands;

    @XmlElement(name = "mapReduceCommandsIncrLoad", required = false)
    private String mapReduceCommandsIncrLoad;

    @XmlAttribute(name = "skip", required = false)
    @Nullable
    protected Integer skip;

    @XmlAttribute(name = "limit", required = false)
    @Nullable
    protected Integer limit;

    @XmlAttribute(name = "batchSize", required = false)
    @Nullable
    protected Integer batchSize;

    public OlapBuilderMongoDbMapReduceDataTable()
    {
    }

    @Override
    public boolean isNameReadOnly()
    {
        return false;
    }

    public String getMapReduceCommands()
    {
        return mapReduceCommands;
    }

    public List<DBObject> getMapReduceCommandsAsDBObject()
    {
        return OlapBuilderMongoDbHelper.asDBObjectList("table:" + getName() + ".mapReduce", mapReduceCommands);
    }

    public List<DBObject> getMapReduceCommandsIncrLoadAsDBObject(Comparable incrLoadMarker)
    {
        final String json = addMarkers(mapReduceCommandsIncrLoad, incrLoadMarker, null);
        return OlapBuilderMongoDbHelper.asDBObjectList("table:" + getName() + ".mapReduceIncrLoad", json);
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "MongoDB Map/Reduce Table";
    }

    @Nullable
    public Integer getSkip()
    {
        return skip;
    }

    @Nullable
    public Integer getLimit()
    {
        return limit;
    }

    @Nullable
    public Integer getBatchSize()
    {
        return batchSize;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator()
    {
        return new OlapBuilderMongoDbMapReduceDataTableValidator();
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context,
                                                                                                  OlapBuilderConnectionPool connectionPool,
                                                                                                  int maxRowCount)
    {
        return new OlapBuilderMongoDbMapReduceTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + getName() + ".mapReduce()");
    }

    @Override
    protected Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection)
    {
        return OlapBuilderMongoDbMapReduceHelper.mapReduceOne(connection, this);
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderMongoDbMapReduceDataTable tableUpdate = (OlapBuilderMongoDbMapReduceDataTable) newTable;

        return !Objects.equals(this.mapReduceCommands, tableUpdate.mapReduceCommands);
    }

}
