/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.find;

import com.mongodb.BasicDBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithPrototypeDataTable;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.bson.BsonValue;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

import static crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader.toBson;

@XmlRootElement(name = "mongoDB-find")
public class OlapBuilderMongoDbFindDataTable extends OlapBuilderMongoDbWithPrototypeDataTable
{
    public static final CdProperty QUERY = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "query", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty QUERY_INCRL_PART = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "queryIncrLoadPart", false)
    {
        @Override
        public boolean isForIncrLoad()
        {
            return true;
        }

        @Override
        public boolean isForPartitioning()
        {
            return true;
        }

        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty PROJECTION = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "projection", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty LIMIT = new CdReadWriteProperty(GROUP_ADVANCED, OlapBuilderMongoDbFindDataTable.class, "limit", false);

    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty(GROUP_ADVANCED, OlapBuilderMongoDbFindDataTable.class, "batchSize", false);

    public static final CdProperty OPTIONS = new CdReadWriteProperty(GROUP_ADVANCED, OlapBuilderMongoDbFindDataTable.class, "options", false);

    public static final CdProperty PARTITION_FIELD = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "partitionField", false)
    {
        @Override
        public boolean isForPartitioning()
        {
            return true;
        }
    };

    @XmlAttribute(name = "limit", required = false)
    @Nullable
    protected Integer limit;

    @XmlAttribute(name = "batchSize", required = false)
    @Nullable
    protected Integer batchSize;

    @XmlAttribute(name = "query", required = false)
    @Nullable
    private String query;

    @XmlAttribute(name = "queryIncrLoadPart", required = false)
    @Nullable
    private String queryIncrLoadPart;

    @XmlAttribute(name = "projection", required = false)
    private String projection;

    @XmlAttribute(name = "options", required = false)
    private String options;

    @XmlAttribute(name = "partitionField", required = false)
    private String partitionField;

    public OlapBuilderMongoDbFindDataTable()
    {
    }

    @Nullable
    @Override
    public String getPartitioningColumnName()
    {
        return partitionField;
    }

    @Nullable
    @Override
    public String getPartitioningColumnNameX()
    {
        return partitionField;
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "MongoDB Find Table";
    }

    @Nullable
    public String getQuery()
    {
        return query;
    }

    @Nullable
    public Integer getLimit()
    {
        return limit;
    }

    @Nullable
    public Integer getBatchSize()
    {
        return batchSize;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator()
    {
        return new OlapBuilderMongoDbFindDataTableValidator();
    }

    @Override
    protected Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection)
    {
        return OlapBuilderMongoDbFindTableRowReader.first(connection, this);
    }

    public String getProjection()
    {
        return projection;
    }

    @Override
    public String getOptions()
    {
        return options;
    }

    @Override
    public void onNewRow(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow data)
    {
        super.onNewRow(context, partitionKey, rowNb, data);
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context,
                                                                                                  OlapBuilderConnectionPool connectionPool,
                                                                                                  int maxRowCount)
    {
        return new OlapBuilderMongoDbFindTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + getName() + ".find()", null);
    }

    @Override
    public boolean hasTablePartitioning()
    {
        return CdStringUtils.isNotNullAndNotBlank(partitionField);
    }

    @Nullable
    public String getQueryIncrementalLoadPart(@Nullable Comparable incrLoadMarker, @Nullable Object partitionValue)
    {
        return addMarkers(queryIncrLoadPart, incrLoadMarker, partitionValue);
    }

    public boolean hasQueryIncrLoadPart()
    {
        return CdStringUtils.isNotNullAndNotBlank(queryIncrLoadPart);
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey)
    {
        return new OlapBuilderMongoDbFindTableRowReader(context, connectionPool, -1, this, "MongoDB " + getName() + ".find()", partitionKey);
    }

    @Override
    protected DistinctIterable<BsonValue> getDistinct(MongoCollection<Document> collection)
    {
        final BasicDBObject bsonQuery = toBson("query", query);
        return collection.distinct(getPartitioningColumnName(), bsonQuery, BsonValue.class);
    }

    public String getPartitionField()
    {
        return partitionField;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderMongoDbFindDataTable tableUpdate = (OlapBuilderMongoDbFindDataTable) newTable;

        return !Objects.equals(this.query, tableUpdate.query)
               || !Objects.equals(this.projection, tableUpdate.projection);
    }

}
