/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.distinct;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTableValidator;

public class OlapBuilderMongoDbDistinctDataTableValidator extends OlapBuilderMongoDbDataTableValidator
{
    public OlapBuilderMongoDbDistinctDataTableValidator()
    {
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderMongoDbConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection> dataTable)
    {
        final OlapBuilderMongoDbDistinctDataTable table = (OlapBuilderMongoDbDistinctDataTable) dataTable;

        validateNotBlankField(context, OlapBuilderMongoDbDistinctDataTable.COLLECTION, table.getCollection());
        validateNotBlankField(context, OlapBuilderMongoDbDistinctDataTable.FIELD_NAME, table.getFieldName());

        validateIsJson(context, OlapBuilderMongoDbDistinctDataTable.QUERY, table.getQuery());

        super.doValidate(context, dataSource, dataTable);
    }


}
