/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

public abstract class OlapBuilderMongoDbWithPrototypeDataTable extends OlapBuilderMongoDbWithCollectionDataTable
{
    public static final CdProperty PROTOTYPE = new CdReadWriteProperty(OlapBuilderMongoDbWithPrototypeDataTable.class, "jsonPrototype", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    @XmlAttribute(name = "jsonPrototype", required = false)
    @Nullable
    protected String jsonPrototype;

    public OlapBuilderMongoDbWithPrototypeDataTable()
    {
    }

    public OlapBuilderMongoDbWithPrototypeDataTable(String tableName, String collection, @Nullable String jsonPrototype)
    {
        super(tableName, collection);

        this.jsonPrototype = jsonPrototype;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderMongoDbConnection connection, OlapBuilderErrorManager errorManager)
    {
        if (CdStringUtils.isNotNullAndNotBlank(jsonPrototype))
        {
            return discoverAllColumnsFromPrototype();
        }

        final Object one = findOneForDiscoverColumns(connection);
        return OlapBuilderMongoDbTableColumnBuilder.discoverColumn(one);
    }

    protected List<IOlapBuilderDataColumnDef> discoverAllColumnsFromPrototype()
    {
        final DBObject one = BasicDBObject.parse(jsonPrototype);
        return OlapBuilderMongoDbTableColumnBuilder.discoverColumn(one);
    }

    public String getPrototype()
    {
        return jsonPrototype;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderMongoDbWithPrototypeDataTable tableUpdate = (OlapBuilderMongoDbWithPrototypeDataTable) newTable;

        return !Objects.equals(this.jsonPrototype, tableUpdate.jsonPrototype);
    }

}
