/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdEnumerableForUi;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import jakarta.xml.bind.annotation.XmlElement;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class OlapBuilderMongoDbWithCollectionDataTable extends OlapBuilderMongoDbDataTable
{
    public static final CdProperty COLLECTION = new CdReadWriteProperty(OlapBuilderMongoDbWithCollectionDataTable.class, "collection", true)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdEnumerableForUi.class /* for now handle as an enum for the sake of simplicity in the UI side */;
        }

        @Override
        public List<String> getPossibleValues(@Nullable Object modelOwner, @Nullable Object model)
        {
            if (model == null)
            {
                return Collections.emptyList();
            }

            final OlapBuilderMongoDbWithCollectionDataTable table = (OlapBuilderMongoDbWithCollectionDataTable) model;
            final OlapBuilderMongoDbDataSource dataSource = (OlapBuilderMongoDbDataSource) table.getDataSource();

            if (dataSource == null)
            {
                return Collections.emptyList();
            }

            return dataSource.getCollectionNamesForUi();
        }

        @Override
        public Object get(Object bean) throws IllegalArgumentException
        {
            final OlapBuilderMongoDbWithCollectionDataTable table = (OlapBuilderMongoDbWithCollectionDataTable) bean;
            return table.getCollectionAsEnumerableForUi(table.collection);
        }
    };

    @XmlElement(name = "collection", required = true)
    protected String collection;

    public OlapBuilderMongoDbWithCollectionDataTable()
    {
    }

    public OlapBuilderMongoDbWithCollectionDataTable(String tableName, String collection)
    {
        super(tableName);

        this.collection = collection;
    }

    @Override
    public String getCollection()
    {
        return collection;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderMongoDbWithCollectionDataTable tableUpdate = (OlapBuilderMongoDbWithCollectionDataTable) newTable;

        return !Objects.equals(this.collection, tableUpdate.collection);
    }

}
