/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import crazydev.common.collection.CdArrayList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

import java.text.ParseException;
import java.util.List;

public abstract class OlapBuilderMongoDbTableRowReaderOld<TABLE extends OlapBuilderMongoDbDataTable>
        extends OlapBuilderAbstractTableRowReader<TABLE, OlapBuilderMongoDbConnection>
{
    @Nullable
    protected Cursor cursor;

    protected CdArrayList<String[]> columnCache;

    protected OlapBuilderMongoDbTableRowReaderOld(OlapBuilderContext context,
                                                  OlapBuilderConnectionPool connectionPool,
                                                  int maxRowCount,
                                                  TABLE table,
                                                  String fullNameForEndUser)
    {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    @Override
    public void doInit()
    {
        initConnection();

        // OlapBuilderMongoDbLoggers.GENERAL.warn("[mongodb] connection - create cursor " + Thread.currentThread().getName());

        cursor = initCursor();

        buildCache(table.getAllColumns());
    }

    protected void buildCache(List<IOlapBuilderDataColumnDef> columns)
    {
        columnCache = new CdArrayList<>();
        for (IOlapBuilderDataColumnDef columnDef : columns)
        {
            final String colName = columnDef.getName();
            final String[] names = colName.split("\\.");

            columnCache.set(columnDef.getIndex(), names);
        }
    }

    protected abstract Cursor initCursor();

    @Override
    public void done()
    {
        if (cursor != null)
        {
            // OlapBuilderMongoDbLoggers.GENERAL.warn("[mongodb] connection - close cursor " + Thread.currentThread().getName());

            cursor.close();
        }

        super.done();
    }

    @Override
    public boolean isRowSafe()
    {
        return true;
    }

    @Nullable
    @Override
    public IOlapBuilderTableRow doNextRow()
    {
        if (cursor == null)
        {
            return null;
        }

        if (cursor.hasNext())
        {
            final DBObject document = cursor.next();

            return OlapBuilderMongoDbTableRow.create(this, document);
        }
        else
        {
            return null;
        }

    }

    public String[] getColumnSplit(IOlapBuilderDataColumnDef columnDef)
    {
        return columnCache.get(columnDef.getIndex());
    }

    public boolean applyDateTimeTZtoDate()
    {
        if (table == null /* faulty tests */)
        {
            return false;
        }

        final OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource) table.getDataSource();
        return ds.applyDateTimeTZtoDate();
    }

    @Nullable
    public DateTimeZone getDateTimeTZ()
    {
        if (table == null /* faulty tests */)
        {
            return null;
        }

        final OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource) table.getDataSource();
        return ds.getDateTimeTZ();
    }

    @FunctionalInterface
    public interface Function
    {
        Comparable parse(String text) throws ParseException;
    }
}
