/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import org.bson.types.BasicBSONList;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public class OlapBuilderMongoDbTableProjectionBuilder
{
    public static final String MONGODB_ID = "_id";

    public static DBObject getProjection(String kind, @Nullable String doc)
    {
        DBObject document = OlapBuilderMongoDbHelper.asDBObject(kind, doc);
        StringBuilder projection = new StringBuilder();

        projection.append("{\n");
        if (document != null)
        {
            final Set<String> keys = document.keySet();

            handleObjectId(projection, keys);

            for (String key : keys)
            {
                if (!key.equals(MONGODB_ID))
                {
                    final Object value = document.get(key);
                    addKeyValue(projection, key, value, false);
                }
            }
        }
        projection.append("}");

        return OlapBuilderMongoDbHelper.asDBObject(kind, projection.toString());
    }

    private static void handleObjectId(StringBuilder projection, Set<String> keys)
    {
        boolean hasId = false;
        for (String key : keys)
        {
            if (key.equals(MONGODB_ID))
            {
                hasId = true;
            }
        }
        if (!hasId)
        {
            projection.append("'").append(MONGODB_ID).append("':0,");
        }
    }

    private static void addKeyValue(StringBuilder projection, String key, Object value, boolean isArray)
    {
        if (value instanceof BasicDBList)
        {
            BasicBSONList list = (BasicBSONList) value;
            addDBList(projection, key, list);
            return;
        }
        if (value instanceof BasicDBObject)
        {
            addDBObject(projection, key, (BasicDBObject) value, isArray);
            return;
        }
        projection.append("'").append(key).append("':1,");
    }

    private static void addDBList(StringBuilder projection, String parentKey, BasicBSONList list)
    {
        if (!list.isEmpty())
        {
            addKeyValue(projection, parentKey, list.get(0), true);
        }
    }

    private static void addDBObject(StringBuilder projection, String parentKey, BasicDBObject value, boolean isArray)
    {
        for (String key : value.keySet())
        {
            addKeyValue(projection, parentKey + "." + key, value.get(key), isArray);
        }
    }

}
