/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.DBObject;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class OlapBuilderMongoDbTableColumnBuilder
{
    public static List<IOlapBuilderDataColumnDef> discoverColumn(@Nullable DBObject document)
    {
        final List<IOlapBuilderDataColumnDef> columns = new ArrayList<>();

        if (document != null)
        {
            return discoverColumn(new Document(document.toMap()));
        }

        return columns;
    }

    public static List<IOlapBuilderDataColumnDef> discoverColumn(@Nullable Document document)
    {
        final List<IOlapBuilderDataColumnDef> columns = new ArrayList<>();

        if (document != null)
        {
            final Set<String> keys = document.keySet();

            for (String key : keys)
            {
                final Object value = document.get(key);

                addKeyValue(columns, key, value, false);
            }
        }

        return columns;
    }

    private static void addKeyValue(List<IOlapBuilderDataColumnDef> columns, String key, Object value, boolean isArray)
    {
        if (value == null)
        {
            columns.add(OlapBuilderDataColumn.createStringColumn(key));
            return;
        }
        if (value instanceof Map)
        {
            addObject(columns, key, (Map<String, Object>) value, isArray);
            return;
        }
        if (value instanceof List)
        {
            List list = (List) value;
            if (!list.isEmpty())
            {
                Set<IOlapBuilderDataColumnDef> setColumns = new HashSet<>();
                for (Object item : list)
                {
                    if (item != null)
                    {
                        List<IOlapBuilderDataColumnDef> listColumns = new ArrayList<>();
                        addKeyValue(listColumns, key, item, true);
                        setColumns.addAll(listColumns);
                    }
                }
                columns.addAll(setColumns);
            }
            return;
        }

        OlapBuilderInputType type = getSimpleType(value);
        columns.add(new OlapBuilderDataColumn(type, value.getClass().getSimpleName(), key, isArray));
    }

    private static OlapBuilderInputType getSimpleType(Object value)
    {
        OlapBuilderInputType type = OlapBuilderInputType.STRING;
        if (value instanceof Number)
        {
            if (value instanceof Integer)
            {
                type = OlapBuilderInputType.INTEGER;
            }
            else if (value instanceof Short)
            {
                type = OlapBuilderInputType.SHORT;
            }
            else if (value instanceof Long)
            {
                type = OlapBuilderInputType.LONG;
            }
            else if (value instanceof Double)
            {
                type = OlapBuilderInputType.DOUBLE;
            }
            else if (value instanceof Float)
            {
                type = OlapBuilderInputType.FLOAT;
            }
        }
        else if (value instanceof java.util.Date)
        {
            type = OlapBuilderInputType.DATETIME;
        }
        return type;
    }

    private static void addObject(List<IOlapBuilderDataColumnDef> columns, String parentKey, Map<String, Object> value, boolean isArray)
    {
        for (String key : value.keySet())
        {
            addKeyValue(columns, parentKey + "." + key, value.get(key), isArray);
        }
    }

    static List<? extends IOlapBuilderDataColumnDef> discoverColumn(Object one)
    {
        if (one instanceof Document)
        {
            return discoverColumn((Document) one);
        }
        else
        {
            return discoverColumn((DBObject) one);
        }
    }
}
