/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBObject;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import org.bson.json.JsonParseException;

public abstract class OlapBuilderMongoDbDataTableValidator extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderMongoDbConnection, IOlapBuilderDataSource<OlapBuilderMongoDbConnection>>
{
    protected OlapBuilderMongoDbDataTableValidator()
    {
    }

    OlapBuilderMongoDbDataTableValidator(boolean validateDataTableAndColumnsWithDataSourceContent)
    {
        super(validateDataTableAndColumnsWithDataSourceContent);
    }

    public static void validateIsJson(OlapBuilderValidationContext context, CdProperty prop, String value)
    {
        if (CdStringUtils.isNullOrBlank(value))
        {
            return;
        }
        try
        {
            BasicDBObject.parse(value);
        }
        catch (JsonParseException exception)
        {
            context.addError(prop, OlapBuilderErrorCode.MONGODB_JSON_ERROR, "JSON", exception.getMessage());
        }
    }

    protected static void validateIsJsonList(OlapBuilderValidationContext context, CdProperty prop, String value)
    {
        if (CdStringUtils.isNullOrBlank(value))
        {
            return;
        }
        try
        {
            OlapBuilderMongoDbTableRowReader.toBsonList(prop.getName(), "BsonList", value, true);
        }
        catch (RuntimeException exception)
        {
            context.addError(prop, OlapBuilderErrorCode.MONGODB_JSON_ERROR, "JSON/JSONARRAY", exception.getMessage());
        }
    }
}
