/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson;

import com.iccube.bson.decoder.ic3BsonObjectBuilder;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdTreeNode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;

public class ic3BsonRowBuilder extends CdTreeNode<String, ic3BsonRowBuilder> implements ic3BsonObjectBuilder
{
    @NotNull
    private final Comparable[] rowValues;

    private IOlapBuilderDataColumnDef col;

    @NotNull
    private IOlapBuilderInputTypeConverter typeConverter;

    private boolean isArray;

    public ic3BsonRowBuilder()
    {
        super();
        this.rowValues = null;
    }

    public ic3BsonRowBuilder(Comparable[] rowValues)
    {
        super(null, null);
        this.rowValues = rowValues;
    }

    private ic3BsonRowBuilder(ic3BsonRowBuilder root, String child)
    {
        super(child, root);
        this.rowValues = root.rowValues;
    }

    @Nullable
    public ic3BsonRowBuilder getForChild(String documentFieldName)
    {
        return getChild(documentFieldName);
    }

    public void setValue(String fieldName, Comparable value)
    {
        if (col == null || !col.isSelected())
        {
            return;  // we don't set not selected values
        }

        final Comparable convertedValue;
        if (value == null)
        {
            convertedValue = null;
        }
        else if (isArray)
        {
            CdComparableArray notConverted = (CdComparableArray) value;
            notConverted = notConverted.expandNestedArrays();
            notConverted.forEachUpdate(v -> v == null ? null : typeConverter.toJavaNativeValue(col.getName(), v));
            convertedValue = notConverted;
        }
        else
        {
            convertedValue = typeConverter.toJavaNativeValue(col.getName(), value);
        }
        rowValues[col.getIndex()] = convertedValue;
    }

    public ic3BsonRow getResult()
    {
        Comparable[] values = new Comparable[rowValues.length];
        System.arraycopy(rowValues, 0, values, 0, rowValues.length);
        Arrays.fill(rowValues,null);
        return new ic3BsonRow(values);
    }

    @NotNull
    @Override
    protected ic3BsonRowBuilder createChildNode(String child)
    {
        return new ic3BsonRowBuilder(this, child);
    }

    public void setIndex(IOlapBuilderDataColumnDef col)
    {
        this.col = col;
        this.typeConverter = col.getType().getTypeConverter();
        this.isArray = col.isArray();
    }
}
