/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson;

import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

public class ic3BsonCodecRegistry4Test implements CodecRegistry
{
    private final CodecRegistry other;

    private final ic3BsonRowBuilder rowBuilder;

    private final OlapProcessingFactsMode mode;

    public ic3BsonCodecRegistry4Test(CodecRegistry other, ic3BsonRowBuilder rowBuilder, OlapProcessingFactsMode mode)
    {
        this.other = other;
        this.rowBuilder = rowBuilder;
        this.mode = mode;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz)
    {
        if (clazz == ic3BsonRow.class)
        {
            return new ic3BsonCodec4Test(rowBuilder, false, mode);
        }
        return other.get(clazz);
    }
}
