/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson;

import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import org.bson.BsonReader;
import org.bson.codecs.DecoderContext;

public class ic3BsonCodec4Test extends ic3BsonCodec
{
    public ic3BsonCodec4Test(ic3BsonRowBuilder rowBuilder, boolean cacheStringValues, OlapProcessingFactsMode mode)
    {
        super(rowBuilder, cacheStringValues, mode);
    }

    @Override
    public Object decode(BsonReader reader, DecoderContext decoderContext)
    {
        return super.decode(reader, decoderContext);
    }

    @Override
    protected ic3BsonRow getResult(ic3BsonRowBuilder rowBuilder, byte[] bytes)
    {
        return new ic3BsonRow4Test(bytes, (ic3BsonRowBuilder4Test) rowBuilder);
    }
}
