/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson;

import com.iccube.bson.decoder.ic3BsonDocumentDecoder;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ic3BsonCodec implements Codec
{
    private final boolean cacheStringValues;

    private final OlapProcessingFactsMode mode;

    private Map<ic3BsonStringBuilder, String> cache = new ConcurrentHashMap<>();

    private ic3BsonRowBuilder rowBuilder;

    public ic3BsonCodec(ic3BsonRowBuilder rowBuilder, boolean cacheStringValues, OlapProcessingFactsMode mode)
    {
        this.rowBuilder = rowBuilder;
        this.cacheStringValues = cacheStringValues;
        this.mode = mode;
    }

    @Override
    public Object decode(BsonReader reader, DecoderContext decoderContext)
    {
        final byte[] bytes = reader.readValueAsBytes();
        return decode(bytes);
    }

    ic3BsonRow decode(byte[] bytes)
    {
        if (mode == OlapProcessingFactsMode.NONE)
        {
            return new ic3BsonRow();
        }

        final ic3BsonBytesBuffer array = new ic3BsonBytesBuffer(cache, bytes, cacheStringValues);
        ic3BsonDocumentDecoder.decodeContent(array, rowBuilder);
        return getResult(rowBuilder, bytes);
    }

    protected ic3BsonRow getResult(ic3BsonRowBuilder rowBuilder, byte[] bytes)
    {
        return rowBuilder.getResult();
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext)
    {
        throw new RuntimeException();
    }

    @Override
    public Class getEncoderClass()
    {
        return ic3BsonRow.class;
    }


}
