/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.ic3BsonBytesBuffer;
import org.joda.time.Chronology;
import org.joda.time.LocalDateTime;
import org.joda.time.chrono.ISOChronology;

public class ic3BsonDateTimeDecoder implements ic3BsonDecoder
{
    static final Chronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();

    @Override
    public void skipValue(ic3BsonBytesBuffer array)
    {
        array.skip(8);
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName)
    {
        long millis = array.getLong();
        LocalDateTime dateTime = toJodaDateTime(millis);
        rowBuilder.setValue(fieldName, dateTime);
    }

    public static LocalDateTime toJodaDateTime(long millis)
    {
        final LocalDateTime localDateTime = new LocalDateTime(millis, UTC_CHRONOLOGY);
        return localDateTime;
    }

}
