## Schema Backups

Schema backups contain all the data required to reload a schema without accessing its data sources.
They contain the data of the initial load as well as the data of all the subsequent activities (e.g.,
incremental loads, load partitions, etc...).

Backups differ from [snapshots](schema_snapshots.md) :

* they are self-contained (the schema definition is included in the backup),
* they load much faster and as such can be used for **hot restart** of an icCube server in a fault-tolerant system.

### Create a Backup

Backups are created while schemas are being loaded. To activate the backup you have to
define a property in the schema definition as following:

![create backup](img/backup_create_large.png)

Then each time the schema is being loaded, a backup will be created. Alternatively, you can request a backup
for a specific load using the [LoadSchema](../../api/LoadSchema.md) REST API using the `forceBackup` parameter.

In case the **backup cannot be created** for whatever reason, this should not fail the load of the schema itself.

### Restoring a Backup

Backups can be restored via the icCube Web interface:

![restore backup](img/backup_restore_large.png)

as well as via the [RestoreBackup](../../api/RestoreBackup.md) REST API.

### Configuration (icCube.xml)

The configuration file `$install/bin/icCube.xml` contains several properties about the backup:

```
<backupDirectory>     : the directory where the backups are saved
<backupConfiguration> : contains several properties controlling how the backups are generated (e.g., compression).
```

Next chapter: [Schema Snapshots](schema_snapshots.md) is explaining what schema snapshots are.

_
