## Docs Permissions

The Docs permissions allows for overriding the files and folders access rights as defined in the Docs
repository.

Permissions are defined using lines of text. Each line defines the access rights for a given path.
A line starting with '--' is a comment and empty lines are allowed. Several kinds of paths are defined:

```
+application /shared/my-application ...     -- A dashboard's application path.
+dashboard   /shared/my-dashboard   ...     -- A dashboard path.
+gadget      /shared/my-gadget      ...     -- A gadget path.
+query       /shared/my-query       ...     -- A MDX query path.
+path        /x/y/z                 ...     -- A free path within the Docs repository.
```

### Empty Profile

An empty profile forbid access to the whole repository.

### Using the Docs Access Rights

The following directory is saying that the role is using the access rights as defined in the Docs
repository itself. Any other directives specified in the profile are ignored. This is the default
value when a new role is being created.

```
+useDocs
```

**Example 1**

The following definition is giving access in read/write mode to the path `/shared/common`
within the `dashboards` folder of the `Docs` repository.

```
+dashboard /shared/common WRITE
```

**Example 2**

The example 1 in read-only mode:

```
+dashboard /shared/common READ
```

**Example 3**

The following definition is giving access in read/write mode to the path `/shared/common`
within the `gadget` folder of the `Docs` repository.

```
+gadget /shared/common WRITE
```

_
