## Creating Schemas/Cubes (aka. Semantic Layer)

icCube's dashboards are accessing your data using an abstraction built on the actual source data : this sort
of metadata is usually called a semantic layer. This semantic layer maps complex data into familiar business 
terms such as product, customer, or revenue to offer a unified, consolidated view of data across your organization.

### Schemas

A schema in icCube represents the semantic layer of your data.

The icCube server is basically a container of schemas that in turn mainly contain cubes. A cube consists of numeric
facts, called measures, which are categorized by dimensions. Dimensions can be shared between cubes within a schema.
Note that an icCube schema is the equivalent of an XMLA catalog.

### Schema Builder

The schema `Builder` allows for creating a schema using a Web based user interface. It allows for defining
all needed parts of a schema: data sources, dimensions, hierarchies, calculated members, etc. Since we feel
that a modern GUI should be as self-explanatory as possible, this user guide will only roughly explain some
of the basic concepts of the user interface, leaving the details for online help. Take into account that in
order to use the builder, some basic knowledge of MDX and multidimensional concepts are beneficial. If you're
new to this field, have a look at our [Gentle Introduction](../../mdx_tutorial/gentle_introduction.md) to MDX
to get familiar with basic concepts.

### Data Sources

icCube provides several ways to create a schema. Whatever the approach, creating a schema always consists
of selecting one or more data-source(s) (e.g. file, Excel sheets, database) containing both the data defining
the dimensions and the facts. Defining additional data source types is possible through the plugin framework
if needed.

### Incremental (aka. Real-Time) Data Sources

Incremental data sources extends regular data sources to support incremental updates of the schemas.
More details are available [here](datasources_rt.md).

### Validating & Deploying a Schema

Once the schema has been fully defined, it can be [validated and deployed](deployment.md). The deployment means 
that the definition of the schema is moved into the folder containing the schemas that can be loaded by icCube. 
Note that building a schema (in the schema builder) does not modify the definition of the deployed schema.

### Walkthrough

This [section](../walkthrough/walkthrough.md) describes an end-to-end example for creating schemas, dimensions,
and measures for an imaginary telecommunications company. By then, you'll be able to modify existing schemas
and/or create new schemas.

### Walkthrough (Incremental Load)

Similar to the previous walkthrough, this [section](../walkthrough/walkthrough_rt.md) demonstrates how to
add real-time (aka. incremental load) support to the cube definition.

Next chapter: [Properties](schema_properties.md) describes various global configuration properties of a schema.

_
