## Sort (ETL)

This transformation allows for sorting a table with parent/child support. Note, it will cache in-memory all rows
and should be used with care with large tables.

Besides a classical sorting it allows for sorting a table defining a parent/child relationship (required
by the parent/child hierarchy builder).

In this example we are going to sort a table for a parent/child hierarchy. The first two columns need to match
bot the `id` and `parent_id` columns; additional columns are used to sort columns inside a node.

### Input

```
id,  parentId, name
111, 11,       Spain
11,  1,        Europe
112, 11,       France
121, 12,       US
12,  1,        America
1,   1,        Root
```

### Output

```
id,  parentId, name
1,   1,        Root
12,  1,        America
11,  1,        Europe
121, 12,       US
112, 11,       France
111, 11,       Spain
```

### Download

The schema with a couple of examples can be downloaded [here](data/Walkthrough_ETL_Sorted.zip).

Next chapter: [Java (Simple Row)](etl_simplejava.md) describes how to define a Java simple row view.

_
