## ETL

The ETL layer in icCube allows for creating new data tables that are the result of transforming/combining
existing data tables. For example, it is possible to transform an Excel sheet with a column to rows transformation.
Or to transform the value of a column based on other column values.

Out of the box, several common transformations are available (e.g., group-by, columns to rows, etc...). A generic
transformation is available using the Java language allowing to define your own transformations.

### Data Views

The ETL support is based on `transformations` (see schema builder: `Data Integration / Transformations`).
A `transformation` (aka. `view` later in this document) is similar to a table; i.e., dimensions and facts can be
built from views and tables with no difference. A view is combining one or more tables (or views) to create
a new tabular data available for building dimensions and facts.

![ETL](img/etl_large.png)

Several transformations are available :

#### Union

Allows for merging one or more tables/views that share the same structure ([www](etl_union.md)).

#### Columns To Rows

Allows for transforming information available over several columns into rows ([www](etl_cols_2_rows.md)).

#### Row to Columns

Allows for transforming information available in one column to generate new columns ([www](etl_row_2_cols.md)).

#### Group By

Allows for merging several rows together ([www](etl_group_by.md)).

#### Join

Allows for joining two tables ([www](etl_join.md)).

#### Sort

Allows for sorting a table (special parent/child support) ([www](etl_sort.md)).

#### Java Code

Allows for defining your own transformation logic using Java language ([www](etl_java.md)).

#### GeoCoding

The GeoCoding transformation allows to generate latitude and longitude coordinates from address data ([www](x)).

Next chapter: [Union](etl_union.md) describes how to perform union of tables.

_
