## Hadoop / Impala (Cloudera)

It is possible to connect icCube to Hadoop/Impala using a JDBC driver.

JDBC drivers are not integrated into icCube, so the first step is to download them using Cloudera/Impala drivers
([link](http://www.cloudera.com/content/cloudera/en/downloads/connectors/impala/jdbc/impala-jdbc-v2-5-5.html)).
Once downloaded copy all JAR files except `log4j*.jar` and `slf4j.jar` to `${icCube-install}/lib`.

Once done and icCube restarted you can create a relational database data source using as parameters :

```
Driver Type : JDBC
Server Name : com.cloudera.impala.jdbc4.Driver
DB Name     : jdbc:impala://yourServer:10000/;auth=noSasl
```    

And your data source is ready to connect to Hadoop.

### Hive (Not Cloudera)

It is possible to connect icCube to Hadoop/Hive using a JDBC driver.

JDBC drivers are not integrated into icCube, so the first step is to download them using Hive drivers (Hive 0.13.1)
([link](http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/HiveJDBCDriver.html)).
Once downloaded 4.1 version, copy all JAR files except `log4j*.jar and slf4j.jar` to `${icCube-install}/lib`.

Once done and icCube restarted you can create a relational database data source using as parameters :

```
Driver Type : JDBC
Server Name : com.amazon.hive.jdbc41.HS2Driver
DB Name     : jdbc:hive2://yourServer:10000
```

And your data source is ready to connect to Hadoop. If you've some freezing issues check your Hive server version
(we're using hive2 in the example) as well as a compatibility between your Hive vendor and the JDBC drivers.

Next chapter: [User Defined](ds_user_defined.md) describes how to extend the icCube with new types of data sources.

_
