## Parent/Child Hierarchy

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

This is also a classical way of defining hierarchies. Here the member parent-child relationship is defined
explicitly with an `id` and a `parent_id` column. This type of dimension does not need the levels defined
in advance.

The root member can be either defined with a null `parentId` or with a `parentId = id`.

### Walkthrough

Let's use the same simple dimension data we used for the multi-level example. As you can see the data does
not implicitly define the level of each member. Only `id`, `parent_id`, as well as `name`, are needed to define
the structure.

```
id, parentId, name,       order, value
1,  ,         World,       2,    
2,  1,        Asia,        2,    2
3,  1,        Europe,      1,    4
4,  3,        Spain,       3,    8
5,  3,        France,      1,    16
6,  3,        Switzerland, 2,    32
```

After creating the new table, defining the `[Geography]` dimension is just a step away :

![parent/child](img/walk-dim-parentchild-hierarchy_large.png)

### Download

You can check the different option with this schema [here](data/Walkthrough_ParentChild.zip).

Next chapter: [Path](dim_path.md)</a>.

_
