## MultiLevel Hierarchy

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

This is the classical way of defining hierarchies.

This type of dimension allows you to define a hierarchy where each level is defined with a table column. 
The member name is mapped with a column, member key can be defined with several columns.

### Walkthrough

We're going to use a little walkthrough to explain how to create a multi-level dimension. First, we need to define
our data. For the sake of simplicity we're going to use the geography dimension with a few members :

```
Continent , Country,        Country_ID
Europe    , France ,        FR
America   , United States,  US
America   , Canada ,        CA
America   , Mexico ,        MX
```

Let's create an embedded data source and create a table with our data :

![datasource](img/walk-dim-multilevel-datasource_large.png)

Once the data is defined, we can begin to build our multi-level dimension : `Geography` :

![dimension](img/walk-dim-multilevel-dimension_large.png)

We will create a single hierarchy for our dimension. This hierarchy will have two levels : `Continent` and `Country`.
Both matching the columns we defined in our table (note we order the members by name) :

![hierarchy](img/walk-dim-multilevel-hierarchy_large.png)

And this is all we need to define our simple `[Geography]` dimension. We can now check the results
in the dimension browser:

![browse](img/walk-dim-multilevel-browser_large.png)

Next chapter: [MultiLevel Advanced](dim_multilevelAdvanced.md).

_
