## icCube Linux

This page describes a typical installation of icCube on a Linux machine.

### Dedicated User

icCube does not require any specific privileges and as such does not need to execute under the `root` user.
We advise creating a dedicated user for running icCube process, let's say `ic3user` for the purpose of this
documentation.

### Installing icCube

Unzip the content of `icCube-8.4.1.zip` for example in the `/opt/icCube` directory, and use a latest link to
reference the latest version installed (e.g., `ln -s 8.4.1/ latest` )

```
/opt/icCube
    /8.4.0
        /bin
        /cubes
        ...
    /8.4.1
        /bin
        /cubes
        ...
    latest -> 8.4.1/
```

### Configuring icCube

Configuring icCube is about updating a bunch of files according to your needs. We advise not changing
the files in the `$install` directory but instead create new files within the `ic3user` home directory.
It is more likely that those files do not need any changes when upgrading icCube. So first create the
following directories:

```
/home/ic3user
    /ic3
        /bin                - directory with a few files for launching icCube and custom configuration
        /data               - this is the fileSystemRoot as seen from icCube (e.g., for CSV files)
        /license            - license file
        /plugins            - user specific plugins
```

Copy within the `/license` directory your own `icCube-4.lic` file.

Copy/unzip within the `/plugins` directory your own icCube plugins if any.

Copy the `/opt/icCube/latest/bin/log4.xml` within the `/bin` directory.

Copy the `/opt/icCube/latest/bin/icCube.xml` within the `/bin` directory and edit it according to your own needs.
You might create a local copy of the original icCube.xml to quickly check for differences or you can check the
differences against the provided `icCube-default.xml` in the `/opt/icCube/latest/bin` directory. Change for example
the `fileSystemRoot` and `additionalPlugins` as follows:

```xml

<icCubeConfiguration>

    <fileSystemRoot value="/home/ic3user/ic3/data"/>
    <additionalPlugins value="/home/ic3user/ic3/plugins"/>

</icCubeConfiguration>
```

Copy the `/opt/icCube/latest/bin/icCube.sh` within the `/bin` directory and edit it according to your own needs.
Our `ic3user` setup should look like:

```
#!/bin/sh

#
# Edit according to your local Java installation.
#
JAVA=java

#
# icCube installation (edit)
#
ICCUBE=$( cd "$( dirname "$0" )/.." && pwd )

#
# icCube configuration file. Use the existing ICCUBE_CONFIGURATION otherwise the default from install.
# Handy when run from a Docker.
#
if [ -z "$ICCUBE_CONFIGURATION" ]; then
ICCUBE_CONFIGURATION=$ICCUBE/bin/icCube.xml
fi

#
# icCube LOG4J configuration file. Use the existing ICCUBE_LOG4J_CONFIGURATION otherwise the default from install.
# Handy when run from a Docker.
#
if [ -z "$ICCUBE_LOG4J_CONFIGURATION" ]; then
ICCUBE_LOG4J_CONFIGURATION=$ICCUBE/bin/log4j.xml
fi

#
# icCube license file. Use the existing ICCUBE_LICENSE otherwise the default from install.
# Handy when run from a Docker.
#
if [ -z "$ICCUBE_LICENSE" ]; then
ICCUBE_LICENSE=$ICCUBE/bin/icCube-4.lic
fi

export ICCUBE_LICENSE ICCUBE_CONFIGURATION ICCUBE_LOG4J_CONFIGURATION

#
# Redefining java.io.tmpdir because cdp4j is attempting to create the folder cdp4j into that directory.
# This might lead to access rights issue when using several icCube users on the machine. Ensure to have
# a different java.io.tmpdir for each user.
#
ICCUBE_USER=$(id -nu)
ICCUBE_TMPDIR=/tmp/$ICCUBE_USER

mkdir -p "$ICCUBE_TMPDIR"

#
# icCube JAVA setup
#
ICCUBE_JAVA_OPTS_EX="-DicCube.install=$ICCUBE -Djava.io.tmpdir=$ICCUBE_TMPDIR"

#
# Use the existing env. ICCUBE_JAVA_OPTS otherwise default to -Xmx512m only.
# Handy when run from a Docker to set the JVM memory (and others).
#
if [ -z "$ICCUBE_JAVA_OPTS" ]; then
  ICCUBE_JAVA_OPTS="--add-opens=java.base/java.nio=ALL-UNNAMED -Xmx512m"
fi

# -----------------------------------------------------------------------------
# Out Of Memory Options
#
# -XX:+HeapDumpOnOutOfMemoryError
#
#     A heap dump is written on the first Out Of Memory Error.
#     There is no overhead involved unless a OOM actually occurs.
#
# -XX:HeapDumpPath=/home/ic3/dumps .
#
#     Note that the dump file can be huge, up to Gigabytes,
#     so ensure that the target file system has enough space.
# -----------------------------------------------------------------------------

#
# exec: when used from a Docker keep PID=1 to make a clean Docker stop
#
exec $JAVA $ICCUBE_JAVA_OPTS $ICCUBE_JAVA_OPTS_EX -cp "$ICCUBE/lib/*" crazydev.iccube.server.IcCubeServer
```

Since icCube 8.2, you can use JAVA system properties instead of environment variables.
See this [page](../configuring_iccube/jre_options.md) for more details.

### Starting icCube

Run the following command as ic3user:

```
# ~/bin/icCube.sh &
```

Next chapter : [Windows Service](service.md).

_