## icCube Data Directory

An icCube server is using several folders as defined in the `icCube.xml` `<directories/>` section. Upon
startup those directories are being created and possibly populated with initial values. The default
configuration is creating the following directories in the icCube user home directory:

    icCube-data
        log              the log files
        tmp              temporary files
        schemaData       data related to loaded schema (e.g., table cache, memory mapped files, ...)
        audit            reports and MDX requests activities
        
        gviService       some cache for the location services used in the Dashboards application
        oauth2           some cache for the Google API datasource
    
        backup           data related to the schema backups
        offline          data related to the schema backups
    
        roles            the definition of the roles                                  (initialized on first startup)
        users            the definition of the users                                  (initialized on first startup)
        tenants          the definition of the tenants
    
                                multi-tenant: for each tenant-directory:                  (initialized when created)
                                    backup / offline
                                    builder / cubes / scheduler / mdxQueries
                                    docsRepository / webPub
    
    
        builder          the definition of the schema being built                     (initialized on first startup)
        cubes            the definition of the schema being deployed for loading      (initialized on first startup)
        scheduler        the definition of both the schema-load-schedules and the alerts
    
        mdxQueries       the MDX queries saved in the MDX IDE                         (initialized on first startup)
    
        docsRepository   the dashboards repository
                         the Dashboards Application repository                        (initialized on first startup)
    
        webPub           a public repository of Web resources accessible from the Dashboards
    
    fileSystemRoot
                            As defined by the fileSystemRoot property, gives access from the builder
                            to the file system specified by this property. This directory is not created
                            and must exist.
    
                                multi-tenant: should contain the $tenants$ folder that is containing
                                a sub-directory for each tenant-directory.

### Sharing the icCube-data Directory

Up until icCube v8.3.0 it is not possible to share the icCube-data directory between different icCube
server instances. A file lock is being used to prevent several instances accessing this folder. This
constraint has been relaxed with icCube v8.4.0. You can refer to this [page](./shared_data_directory.md)
for more details.

Next chapter: [Sharing the icCube Data Directory](shared_data_directory.md).

_