## Real Time Edition

What if you could get instant answers to the most complex and challenging queries against your operational
and historical data? With the real-time edition we believe and demonstrate that MDX can be used with such
real-time constraints. By accelerating key business processes, the icCube real-time edition is opening the
door to innovative data-driven business models.

### icCube Calculation Engine Evolution

The underlying icCube real-time engine is an evolution of our standard engine meaning
all features available in the standard editions are still here; its strong analytical capabilities has not
been sacrificed for speed efficiency. The engine has been carefully designed to allow queries at the same
time new data is read from the real time data sources keeping data consistency and allowing a seamless
operation.

### Improved Incremental Load

The real time edition leverages the incremental load feature as described in more details
[here](../schemas_cubes/datasources_rt.md). Whereas in the standard enterprise edition
the incremental data-sources are more about refreshing the cubes once in a while, the real time
edition makes heavy use of this feature to refresh the cube as often and as soon as the latest operational
data becomes available.

Note that the calculation engine is still available to process MDX requests while the underlying cubes are
being refreshed. Carefully crafted algorithms allows for minimizing as much as possible the 'downtime' of
the schemas because of actual updates of their data. A 'downtime' freezes the schema for time periods of
milliseconds making queries on the schema wait until completion.

### Optimized Multi-Core MDX Processing

On top of the incremental load feature, the real time edition would be nothing without a very fast
MDX calculation engine. Thanks to this latest engine, the updated cubes are immediately available
for processing; i.e. there is no need for lengthy post-processing (e.g. building caches). You can
typically still expect sub-second MDX queries on the just refreshed cube.

<h3>Hardware / OS Requirements</h3>

Last but not least, our real time icCube engine is still available on commodity machines able to run
a JAVA virtual machine meaning there is for example no need for complex GPU setup making it ideal to
deploy on private/public cloud platforms.

Next chapter: [Partitioning Edition](partitioning_edition.md)

_
