## Configuration

An icCube plugin is a JAR file containing JAVA classes and a `META-INF/plugin.xml` file describing its content.
For example, here is the definition of one plugin shipped with icCube. This plugin adds new functions to the icCube
engine:

```xml

<plugins xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:noNamespaceSchemaLocation="https://downloads.iccube.com/schemas/icCubePlugins.xsd">

    <name>icCube</name>

    <javaFunctions
            moduleName="VBA"
            className="crazydev.iccube.plugin.olapfunctions.excel.OlapVBExcelNumericalFunctions"
            overwriteMain="false"
            overwriteModule="false"
    />

    <javaFunctions
            moduleName="VBA"
            className="crazydev.iccube.plugin.olapfunctions.excel.OlapVBExcelTextFunctions"
            overwriteMain="false"
            overwriteModule="false"
    />

    <olapStatFunction
            mdxFunctionName="HVaR"
            mdxFunctionDescription="Calculate Historical VaR"
            className="crazydev.iccube.plugin.olapfunctions.stats.OlapHVaRFunction"
            overwriteExisting="false"
    />

    <olapStatFunction
            mdxFunctionName="WAvg"
            mdxFunctionDescription="Calculate Weighted Average"
            className="crazydev.iccube.plugin.olapfunctions.stats.OlapWAvgFunction"
            overwriteExisting="false"
    />

    <olapFunction
            className="crazydev.iccube.plugin.olapfunctions.OlapStrToLevelFunction"
            overwriteExisting="false"
    />

    <olapFunction
            className="crazydev.iccube.plugin.olapfunctions.OlapStrToHierarchyFunction"
            overwriteExisting="false"
    />

</plugins>
```

The directory `icCube/plugins` contains the plugins and their associated dependencies (i.e. 3rd party JARs)
as well as the source code of the plugins shipped with icCube (ZIP files). The plugin configuration and the list
of plugins (as well as their content) is accessible using the Web monitoring console as shown in the following image:

![plugins](img/monitoring_plugins_large.png)

The following image shows the actual content of the selected plugin (i.e. a list of MDX functions):

![icCube plugin](img/iccube_plugin_large.png)

Next chapter: [Examples](examples.md) describes several working examples.

_
