## $Audit

icCube can audit several internal activities. This can be configured via the `icCube.xml` file
in the section `monitoringConfigurations` via the `auditFilter` section. The auditing information
is persistent and will be accessible on icCube restart (directory `icCube-data/audit`).

**Opened Reports**

Auditing opened reports is activated using:

```xml

<auditFiler>report</auditFiler>
```    

**MDX Requests**

Auditing elapsed time of MDX requests is activated using:

```xml

<auditFiler>mdx[:N]</auditFiler>
```

N is an optional parameter that allows for auditing requests whose elapsed time is greater than N seconds.

**$Audit Schema**

Once installed, icCube contains in the builder directory an example of schema using the `mdx.csv` file.
This schema is called `$Audit` and can be (re)deployed if required (you can set up a schedule task for
updating it: its definition has activated incremental load). Feel free to change it for your own convenience.
Remember to activate the monitoring (`icCube.xml`) to have the required audit files available.

## Audit (Legal)

In `icCube.xml` you can specify a new monitoring reporter that is generated audit information used
for legal reporting:

```
IcBigBrotherLegalAuditReporter
```

This information is very much similar to the information as generated for the `$Audit` schema as
described above with the following differences:

There is no limit in the number of files generated. So you're able to keep all the information you want.
The file sequence will be `mdx.csv.0`, `mdx.csv.1`, ... `mdx.csv.N` where .N is the latest and current
(and only) file used by icCube. All other previous files can be copy (or move) to a secure place. You can
merge all those files to generate the whole data set.

The audit filter `mdx:N` where N is a threshold in seconds does not apply. All MDX requests are audited.

In case of any error while writing the audit information
a [notification](../configuring_iccube/iccube_notification_xml.md)
(as an `INTERNAL_ERROR`) is being generated.

_
