## Migrating icCube : 8.3.0 to 8.4.0

The icCube 8.4.0 server is a maintenance release that is backward compatible with icCube 8.3.0.
Please **review carefully** this document and **backup your existing installation before starting
v8.4.0 over an existing v8.x installation**.

### Java 17 (LTS)

Java 17 (LTS) is being required to run icCube. Note that several libraries (both in /lib and /plugins folders)
have been updated to their latest version. Please ensure to test first this new server is fine in your DEV/QA
environment.

### ETL

The Javascript views are not supported anymore. Please use the similar Java view instead.

### Passwords

The password hashing algorithm has been updated. You can regenerate your passwords used for email
notifications, the schema definition passwords will be automatically updated on first schema save.

### Docs (Dashboards App.)

The layout of the Dashboards application in the /ic3-reporting folder has been changed; upon startup
icCube is migrating existing deployed applications and backups.

The following folders are moved:

    /ic3-reporting
        /app
        /plugins
        /help
        /doc

into a containing app folder:

    /ic3-reporting
        /app
            /app
            /plugins
            /help
            /doc

The same processing is done for each existing backup:

    /ic3-reporting/app-backups
        /2023-01-23 10-24-21
            /app
                /app
                /plugins
                /help
                /doc
        /...

The externals hosting has been removed. Please contact us if you were using it.

### Docs (DB)

The DB repository is not supported anymore. Please contact us if you were using it. Note that the
current file system repository is being improved for a shared usage.

### Audit

The tenant information is being added (when the multi-tenant option is activated) as a new column
before the USER_NAME column. Any existing audit files are left unchanged.

### MultiTenant

The single tenants directory has been split into two separate directories: one containing the definitions
of the tenants and the other one containing the actual data of the tenants. No migration is performed by
icCube when starting. You need to manually update your existing icCube.xml and tenants directory.

Your existing icCube.xml should contain a single directory as following:

    <multiTenantDirectory value="${icCube.directories.dataDirectory}/tenants">;

That should be changed as following:

    <tenantsDirectory value="${icCube.directories.dataDirectory}/tenants">
    <multiTenantDirectory value="${icCube.directories.dataDirectory}/tenantsData">

where the `tenantsDirectory` contains the definitions and the `multiTenantDirectory` the data.

The existing `icCube-data/tenants` directory can then be renamed into `icCube-data/tenantsData`
and the `icCube-data/tenants` directory can be re-created.

The file `/icCube-data/tenantsData/icCubeTenants.icc-tenants` can be moved into the `icCube-data/tenants` directory.
Same for the possibly existing folder `/icCube-data/tenantsData/icCubeTenants.icc-tenants.revs`.

Add the folder possibly missing `webPub` folder into each tenant folder:

    /icCube-data
        /tenantsData
            /france
                /backup
                ...
                /webPub
            /spain
                /backup
                ...
                /webPub

### Roles/Users

Very old format (pre-2018) of the icCubeRoles.icc-roles and icCubeUsers.icc-users are not migrated anymore.
Please contact us if you were using this old format.

### Scheduler

Very old existing icCubeScheduler.icc-scheduler file is not migrated anymore.
Please contact us if you were using this old format.

_