## Analysis Services AdomdClient

For C# fans, here is a short example executing a simple MDX select against icCube using `AdomdClient` :

```cs
using System;
using System.Globalization;
using System.Threading;
using Microsoft.AnalysisServices.AdomdClient;
using System.Data;

namespace DemoApp
{
    internal class Program
    {
        static void Main(string[] args)
        {
            using (AdomdConnection mdConn = new AdomdConnection())
            {
                Thread.CurrentThread.CurrentUICulture = new CultureInfo("en-us");

                mdConn.ConnectionString = "Initial Catalog=Sales;Data Source=http://192.168.1.8:8282/icCube/xmla;";
                mdConn.Open();

                string query = @"
                    select 
                        { [Measures].[Amount], [Measures].[Count] } on 0
                        [Customers].[Geography].[Region] on 1
                    from[Sales]
                ";

                // string query = "drillthrough maxrows 10 select [Measures].[Count] on 0 from[Sales]";

                AdomdCommand command = new AdomdCommand(query, mdConn);

                DataTable tbl = new DataTable();

                AdomdDataAdapter adapter = new AdomdDataAdapter(command);
                adapter.Fill(tbl);

                Console.WriteLine("Row Count : " + tbl.Rows.Count.ToString());

                Console.WriteLine("--");
                for (int cc = 0; cc < tbl.Columns.Count; cc++)
                {
                    Console.Write(tbl.Columns[cc].ColumnName + ",");
                }
                Console.WriteLine();
                Console.WriteLine("--");

                for (int rr = 0; rr < tbl.Rows.Count; rr++)
                {
                    for (int cc = 0; cc < tbl.Columns.Count; cc++)
                    {
                        Console.Write(tbl.Rows[rr].ItemArray[cc] + ",");
                    }
                    Console.WriteLine();
                }

                Console.ReadKey();
            }
        }
    }
}
```

Next chapter: [SeekTable](seekTable.md) is describing how to connect SeekTable to icCube.

_
