## Excel

Excel is connecting to icCube via the [XMLA](../../user_guide/running_iccube/xmla.md) connector. This page is
describing how to create a connection and pivot tables as well as several [frequently asked questions](#faq)
related to the usage of Excel with icCube.

### Microsoft 365

Get data using Analysis Services source :

![from SSAS](img/e365_from_ssas.png)

Then enter the icCube XMLA URL and username/password :

![connect](img/e365_connect_db.png)

Select the icCube schema and cube you'd like to connect to :

![schema](img/e365_select_schema.png)

Press finish to save the new connection :

![finish](img/e365_finish.png)

You can create a pivot table now :

![pivot](img/e365_pivot.png)

### Microsoft 365 (Import Query)

Get data using Analysis Services source :

![Import Query from SSAS](img/e365_pq_from_ssas.png)

Then enter the same icCube URL as explained earlier in this document and then select both the measures and dimensions
you'd like to import. Alternatively, you can directly enter an MDX statement :

![Import Query from SSAS_mdx](img/e365_pq_mdx.png)

### Excel 2007/2010

The following section describes how to create a pivot table using Excel 2007. Note that the connection
string generated is:

```
Provider=MSOLAP.4;Persist Security Info=False;Location=http://localhost:8282/icCube/xmla;Initial Catalog=Sales (Excel)
```

Due to several issues with the OLE DB provider (i.e., lack of prompting user credentials when not using Windows
Integrated Authentication), it is strongly recommended to download the latest Microsoft SQL Server 2008 Analysis
Services OLE DB Provider as
described [here](http://www.microsoft.com/downloads/en/details.aspx?FamilyID=1b2bd555-cb5b-47b9-88c7-3f89f3b43779#QuickDetails).

So let's create a pivot table...

![create pivot-table](img/create_pivot_table_large.png)

Select `Choose Connection` :

![choose connection](img/choose_connection_large.png)

Click `Browse for more` :

![browse for more](img/browse_more_large.png)

Click `New Source` :

![new source](img/new_source_large.png)

From here you have **two options** :

Either Select an **MS Analysis Driver** :

![msas](img/msas_large.png)

Set the server location (`http://localhost:8282/icCube/xmla`) corresponding to the icCube
XMLA interface (HTTP location as defined in [icCube.xml](../configuring_iccube/iccube_xml.md)
and available in the [monitoring](../configuring_iccube/accessing_configuration.md) WEB interface).

![msas](img/msas2_large.png)

You can now jump directly
to [Select the Schema and Cube bound to the Data Source](#select-the-schema-and-cube-bound-to-the-data-source).

Or Select **Other/Advanced** :

![other](img/other_large.png)

Select an `OBDO` driver :

![obdo](img/odbo_driver_large.png)

Then set the parameters of the data source starting with its location (`http://localhost:8282/icCube/xmla`)
corresponding to the icCube XMLA interface (HTTP location as defined
in [icCube.xml](../configuring_iccube/iccube_xml.md)
and available in the [monitoring](../configuring_iccube/accessing_configuration.md) WEB interface).

![excel connection](img/excel_http_large.png)

#### Select the Schema and Cube bound to the Data Source

![select schema](img/select_schema_cube_large.png)

Then save and open the pivot table :

![pivot-table](img/pivot_table_large.png)

### FAQ

#### Anonymous Authentication

When anonymous logon is activated (default in icCube.xml) it is taking precedence over for example the
`username/password` as defined in Excel (same for ADOMD.NET). Therefore, to connect with a `username/password`
you must de-activate the anonymous logon within the `HTTP Basic Authentication` filter configuration within
the `icCube.xml` file.

#### Refresh Frozen

When opening an existing pivot table and refreshing it might block Excel; pressing `ESCAPE` should solve this
issue and refreshing again the pivot table should work now.

#### Calculated Member/Measure Drillthrough (aka. Show Details)

Excel does not trigger any `Show Details` action for cells containing a calculated member. But icCube is adding
by default an `Additional Actions` that is performing a drillthrough for that cell as icCube is supporting it.
The drillthrough is then containing the rows used by the actual measures of the calc. member.

#### Drillthrough (aka. Show Details) MAXROWS 1000

By default, icCube is configured to return at most 1000 rows if the `MAXROWS` is not specified in the drillthrough 
statement. This value can be changed via the property `drillthroughDefaultMaxRows` in the file `icCube.xml`.

#### Additional Details

See the [actions](../schemas_cubes/adv_actions.md) document for creating new drillthrough actions that will be
displayed in the 'Additional Details' of the contextual menu of the pivot tables.

### Limitations

Although we have made every effort to incorporate as many Excel pivot table features as possible, there may 
still be some features that have not yet been implemented. If you encounter any limitations or need assistance, 
please don’t hesitate to [reach out](https://www.iccube.com/contact-us/) to us. We're here to help!

Next chapter: [Power BI](power_bi.md) is describing how to connect Power BI to
icCube.

_
