## Authentication Overview

### Servlet Filters

icCube is following J2EE standards. As such, it is accessed via a set of servlets (e.g., XMLA, reporting,
cube builder, monitoring, etc...). Accesses to these servlets are authenticated using the standard servlet
filter mechanism as defined in `icCube.xml` configuration file.

### Authentication Service

On top of servlet filters, icCube provides an authentication service that is based on user definitions
stored in the file `icCubeUsers.icc-users` available in the application users directory.
When starting icCube for the very first time, the initial content of this file is sourced from the
file available in the bin directory of the icCube installation directory.

If needed you can provide your own authentication service (i.e., Java class) via the
`<icCubeAuthenticationService>` configuration in the `icCube.xml` file.

### On-The-Fly Authorization

The authentication service and servlet filters, unless otherwise specified, are assuming that users
are using roles (aka. access rights) as defined in icCube. Nevertheless, it is possible to create
a role description once the user has been successfully authenticated (aka. on-the-fly role). This
role can then match exactly your own requirements and does not need to be stored in icCube. This
scenario is pretty well suited for embedded installation when users and their access rights are more
likely defined elsewhere. More details can be found [here](../../../devops/OnTheFlyAuthorization.md).

Next chapter : [Default Authentication](authentication.md) describes default user's authentication.

_

