## Apache (Web Server) & icCube

icCube is following J2EE standards (e.g., servlets) and as such can be setup to work with any web server.
This page is explaining how to set up Apache and icCube for a typical production environment.

### Apache Configuration Overview

Apache is configured to act as a reverse proxy forwarding all the requests to icCube and authenticating
the users. Connections between Apache and icCube are then considered as trusted, leaving to icCube the
task to authorize the users. Here is an extract of the Apache configuration file:

```
ProxyRequests Off

<Proxy *>
Order deny,allow
Allow from all
</Proxy>

ProxyPass        /icCube http://icCube-server-address:8282/icCube
ProxyPassReverse /icCube http://icCube-server-address:8282/icCube

ProxyPass        /xmla   http://icCube-server-address:8282/xmla
ProxyPassReverse /xmla   http://icCube-server-address:8282/xmla

ProxyPass        /gvi    http://icCube-server-address:8282/gvi
ProxyPassReverse /gvi    http://icCube-server-address:8282/gvi

ProxyPreserveHost On
ProxyStatus       On        
```

Note the different icCube URLs. Having `/xmla` and `/gvi` at the same level as `/icCube` is not mandatory
but allows for an easier security configuration (see below).

### icCube Authentication Servlet Filter

In this configuration, Apache is configured to authenticate users using the `HTTP Basic Auth`.
This is done as follows:

```xml

<icCubeConfiguration>

    <xmlaComponentConfiguration>
        <filter>XMLA (Apache) Authentication</filter>
    </xmlaComponentConfiguration>

    <gwtServiceComponentConfiguration>
        <filter>GWT (Apache) Authentication</filter>
    </gwtServiceComponentConfiguration>

    <gviComponentConfiguration>
        <url>/gvi</url>
        <filter>GVI Authentication</filter>
    </gviComponentConfiguration>

    <filterConfiguration>
        <filter>
            <filter-name>XMLA (Apache) Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeApacheAuthenticationServletFilter</filter-class>
        </filter>
        <filter>
            <filter-name>GWT (Apache) Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeApacheGwtAuthenticationServletFilter
            </filter-class>
        </filter>
        <filter>
            <filter-name>GVI Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeGviRequestAuthenticationServletFilter
            </filter-class>
            <init-param>
                <param-name>anonymousLogon</param-name>
                <param-value>false</param-value>
            </init-param>
        </filter>
    </filterConfiguration>

</icCubeConfiguration>
```

### Apache Security

Apache is configured to perform authentication using `HTTP Basic Auth`. As this authentication is not secured,
it is recommended, for a production environment, to set up Apache to use HTTPS instead of plain HTTP. The
following shows how to set up an authentication profile for each icCube interface:

```
<Location /icCube>
    AuthType Basic
    AuthName "icCube"
    AuthBasicProvider file
    AuthUserFile /etc/apache2/passwords
    Require user demo
</Location>

<Location /xmla>
    AuthType Basic
    AuthName "icCube"
    AuthBasicProvider file
    AuthUserFile /etc/apache2/passwords
    Require user demo
</Location>

<Location /gvi>
    AuthType Basic
    AuthName "icCube"
    AuthBasicProvider file
    AuthUserFile /etc/apache2/passwords
    Require user demo 
</Location>    
```

### icCube Users & Roles Definitions

As described above, icCube is going to authorize users and as such must know about the list of users
and their associated roles. More details can be found [here](../security/user_definitions.md).
Note that this is not required to define user password within the context of the configuration explained
above as icCube is going to assume the users have been authenticated by Apache.

Next chapter : [NGINX (Web Server)](nginx_web_server.md) & icCube.

_
