## Release Notes

<hr/>

### 9.0.0

<hr/>

**IMPORTANT** : icCube 9.0 is a major release so please review carefully
the [migration](user_guide/migrating_iccube/8_6_2_to_9_0_0.md) document to ensure your existing production
environment can be properly migrated. For example, you need to remove several deprecated configurations from
your existing `icCube.xml` file first before starting icCube 9.0. 

**IMPORTANT** : Java 25 is being required to run icCube.

`Server`

- Fixed browser caching issue for the admin console. Please clear your browser cache before accessing the admin
  console page. This ensures you are loading the console page of version 9.
- Java classpath : the `/plugins` folder has been added to the Java classpath in the `icCube.sh` file.
  Please update your own startup file accordingly.
- Embedding the Server UI : the iframe `src` is not limited anymore to `/icCube/console/` path. For example,
  `/cs-admin/console/` could be used instead to better support your own reverse proxy logic.
- On top of the notification, the Server UI is now displaying a license expiry warning.
- Fixed (auto)cancelling MDX requests sent by the Dashboards application when `sessionLess = true`.

`Alerts`

- Set an alert on error if the PDF cannot be generated. The alert will then be disabled if the option
  `Continue on Error` is not checked (was ignored).
- New actions : `Duplicate`, `Enable`, and `Run Now`.
- New bulk mode : `Enable`, `Disable`, `Run Now` and `Delete` actions can be executed with a list of alerts.
- New Rest API: [RunNowAlert](api/RunNowAlert.md).

`MDX`

- Introduced the `Dimension Properties` tidy post-processor for adding members properties as result columns
  instead of using costly crossjoins : more details [here](post_processing/DimensionProperties.md).
- Check the new `NON EMPTY` crossjoin configuration (`icCube.xml : mdxEvalConfiguration : neCj...`) for
  improved performance (parallel execution, cache, etc...).
- Add a 4th parameter to `Order` , EXCLUDEEMPTY, to filter out empty values.
- `dtAsOfToday`, `dtAsOfYesterday` work with non day levels (i.e. year, months).
- `dtAsOfToday` as an optional parameter to define a delta from today's date.
- New [Zip](../server/mdx/Zip.md)() function.
- New [NonEmptyMembers](../server/mdx/NonEmptyMembers.md)() function.
- New [UnknownMembers](../server/mdx/UnknownMembers.md)() function.
- New `STR_NUMBERS` option in [LookupByKeys](../server/mdx/LookupByKeys.md)() function.
- Fix MDX queries with a drillthrough and column aliases: e.g., `return .. as "Product"` returned an error
  when there were no rows in the result. Now it returns an empty table as expected.
- Fix MDX debugger showing `loading...` nodes.
- Fix `subCubeMinus` when the second parameter is a set with more than 10 tuples.
- Fix `NaN/Infinity` values serialization in table column (was serializing first value only).
- Support for Renjin has been removed. Please contact us for more information and/or help.

`Schema Builder`

- **The "Index and Facts in Files" feature is back**. The following configuration properties in `icCube.xml` have been
  removed : `indexFileSize`, `indexFileBufferSize`, `indexBufferSize`, `factsIndexFileSize`, `factsIndexBufferSize`,
  `factsIndexFileBufferSize`. They were either deprecated and/or not used.

- Distinct count measures : faster processing at the end of the schema load. Note that more RAM might be required.

- JDBC data source : connections are now created with `setAutocommit(false)` to fix Postgres|Redshift memory usage.
  In case of issue with this, there is a new `Advanced` property in the definition of each datasource to switch off
  this behavior.

- New table action : `Export to XLSX` for exporting the table content to Excel file.

- Geo Coder transformation : removed the ETL view.

- Google Analytics : removed deprecated datasource. Use Google Analytics v4 instead.

- Redshift : fix missing AWS JAR.

- The "Facts in Files" configuration properties in `icCube.xml` have been removed : `factsColumnFileSize`,
  `factsColumnFileBufferSize`, `factsColumnBufferSize`. They were either deprecated and/or not used.

- [Custom aggregation](user_guide/schemas_cubes/facts_custom_aggregation.md) (aka., table aggregator) written
  in Java have been introduced. Note this is still a **beta** feature. Contact us for more informant and/or help.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#900-alpha6-next-version).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.6.2 : [details](user_guide/migrating_iccube/8_6_2_to_9_0_0.md).

<hr/>

### 8.6.2

<hr/>

**IMPORTANT** : Support for facts pre-aggregation when building measure groups has been deprecated/removed.
Please contact us if you were using this feature.

**IMPORTANT** : Deprecated many-2-many facts has been removed. This can be replaced using bridges.
Please contact us if you were using this feature.

**IMPORTANT** : 'If Null/Empty Use' field in the columns of builder tables handle strings composed solely of
spaces as well. This might change your schema.

`Server`

- On-the-fly authorization : the $$ processing (i.e., header replacement) in authorization script
  is now case-insensitive.

- On-the-fly authorization : the `Docs` part of the template role was ignored. Now the generated role
  definition is based on the `Docs` as defined in the template role. Similarly to the `Schemas` part, $$
  replacement is performed as well.

- Rest API : the [TidyExecuteMdxScript](api/TidyExecuteMdxScript.md) request is using the MDX result cache.

`AI Chatbot`

- Support for Azure OpenAI (see `icCube.xml` new section : `azureOpenAI` in `aiConfiguration`).

`MDX`

- Introduced the configuration `icCube.mdxSumAlgo` in the file `icCube.xml` to control how **double values**
  are aggregated (aka. sum) to minimize rounding errors. When not defined, the `STANDARD` method is being used
  as before. That is, all values are aggregated using the sum operator and no specific logic is being applied
  to minimize rounding errors. New installation of icCube using the default `icCube.xml` file will use
  the [NEUMAIER](https://en.wikipedia.org/wiki/Kahan_summation_algorithm)  summation. More details in
  the [migration](user_guide/migrating_iccube/8_6_1_to_8_6_2.md) document. There should be not significant
  **performance** impact regarding the processing of the MDX queries; however, **we recommend verifying**
  this with your schema.
- The new MDX Eval Profile configuration `internalTupleListCountCJ` is possibly used to limit the size of
  materialized sets in crossjoin evaluation.
- New MDX function `WithFormattedValue()` (more details in [FORMAT_STRING](mdx/cellProperties.FORMAT_STRING.md)).
- Fix potential `Illegal Capacity` error in crossjoin.

`Schema Builder`

- Add a new [aggregation type](user_guide/schemas_cubes/facts_aggregation.md) for measures : `Sum (high precision)`.
  It currently uses the Neumaier algorithm to sum double values. You can use it to reduce rounding issues when
  needed. Feel free to contact support for more information.

- Fix the `Week` level in a time dimension : the week definition depends on the **country** of the locale as defined
  in the time dimension (or hierarchy). Note that using for example English (`en`) or French (`fr`) locale is not
  enough as they do not define any country : use instead United States (`en_US`) or France (`fr_FR`) to ensure the
  weeks are properly defined. When no locale is defined, icCube
  uses [ISO-8601 definition](https://en.wikipedia.org/wiki/ISO_week_date).

- Cubes and measure groups order not changed when saving of the `.icc-schema` file (keeping source control happy).

- The name of a dimension cannot be used anymore as a cube name. Use the property `icCube.dimensionCubeNameUnique`
  in the file `icCube.xml` to revert to the old behavior.

- The `Reverse Index` has been deprecated. Refer to this [page](user_guide/migrating_iccube/8_6_1_to_8_6_2.md)
  for more details.

- The table column `Is Null/Empty Use` behavior is taking into account strings containing only white spaces as well.
  The option has been renamed into `Is Null/Blank Use`.

- Fix missing clear cache for JOIN views.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#862).

`Libraries`

- Upgraded several libraries to their latest version.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.6.1 : [details](user_guide/migrating_iccube/8_6_1_to_8_6_2.md).

<hr/>

### 8.6.1

<hr/>

**IMPORTANT** : The icCube server 8.6.1 is a maintenance release fixing the regression introduced
in the `LookupByKey()` MDX function for indexing by range (e.g., time) dimensions.

**IMPORTANT** : The icCube server 8.6.1 requires the Dashboards application 8.6.1 being deployed : the MDX Console
(aka. MDX IDE) is now sharing its code with the deployed/installed reporting application for consistency purpose.
You can expect common improvements regarding the query builder in the future releases of icCube.

`MDX`

- Revert the change of the behavior of the `LookupByKey()` function as introduced in 8.6.0.

- New function [IsFiltering](mdx/IsFiltering.md).

- Fix member lookup in level when using `&[name]` notation and `name` contains `]` characters.

- Fix member name unescape when containing two following (and more) `]` characters.

`Alerts`

- Fix potential lock when several alerts triggered at the same time are exhausting the resources
  of the MDX executor when evaluating their trigger MDX expression.

`Schema Builder`

- ETL Views/Transformations : fix Geo Coding for unselected column(s) in underlying table.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#861).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.6.0 : [details](user_guide/migrating_iccube/8_6_0_to_8_6_1.md).

<hr/>

### 8.6.0

<hr/>

**IMPORTANT** : The icCube server 8.6.0 requires the Dashboards application 8.6.0 being deployed : the MDX Console
(aka. MDX IDE) is now sharing its code with the deployed/installed reporting application for consistency purpose.
You can expect common improvements regarding the query builder in the future releases of icCube.

`MDX`

- New MDX Console (aka. MDX IDE). The MDX queries are saved into the `Docs` (`ic3-reporting/data/gizmos/queries`)
  repository. Existing queries are migrated and saved into the `shared` folder.

- New MDX Eval Profile configuration : `internalTupleListCount`. This configuration limits the maximum number
  of tuples that the `Filter`, `NonEmpty`, `Order` and `Top-like` MDX functions can store. See the section
  `mdxEvalConfiguration` in the file  `icCube.xml` for more details. Note this limitation does not apply to
  permissions expressions.

- New `Filter()` and `NonEmpty()` configuration : `icCube.mdxEvalFilterProcessingMode`. By default, the server
  is using the new `ITERATOR` processing mode. See the property in the file `icCube.xml` for more details.

- Add `EXCLUDEEMPTY` flag to Top/Bottom -Count, -Percent and -Sum MDX functions.

- New `Description()` function retrieving the [description](../server/mdx/Description.md) of the schema entities
  (e.g., dimension, hierarchy, etc...).

- The `LookupByKey()` function for indexing by range (e.g., time) dimensions **returns null** for members
  (e.g., dates) before the lower bound and for members (e.g., dates) after the upper bound (instead of first
  or last defined member).

`Schema Builder`

- Time wizard uses the locale defined in the hierarchy to define the first day of the week (i.e., Sunday for the US).

- Add a description field to every schema entity : this description is now available in the schema browser of both
  the graphical and the textual query builder in the dashboard application as well as in the MDX console.

`Alert`

- Dashboard path can be edited using a file explorer and UI cleanup of the attachment definition.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#860) and <b>note the MDX Query Builder widget
  has been temporarily removed</b>.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.5.0(.1) : [details](user_guide/migrating_iccube/8_5_0_to_8_6_0.md).

<hr/>

### 8.5.1

<hr/>

icCube 8.5.1 is a maintenance release fixing several regressions in the [Dashboards](../dashboards/ReleaseNotes.md#851)
application.

<hr/>

### 8.5.0

<hr/>

**IMPORTANT** : 8.5.0 is changing how colliding names and (string) keys are handled when loading a schema.
Please **review carefully** the [document](user_guide/migrating_iccube/8_4_14_to_8_5_0.md) before migrating your
production environment.

`Server`

- Windows : the `icCube.exe` is not shipped anymore. You can use the `icCube.bat` file instead that can be
  wrapped as a service using [NSSM](../server/user_guide/running_iccube/service.md) if required or better
  use the available Docker image. [Contact us](https://www.iccube.com/contact-us/) for more details.

- Print : introduced the icCube print [Docker](https://hub.docker.com/r/ic3software/print) that allows for
  separating the actual Chrome|Chromium headless process from the icCube Docker image itself. You can refer
  to the Docker page for the configuration details.

`Alert`

- Fixed export [widget data](../server/user_guide/using/schema_alerts.md#widget-data-export)
  (XLSX, CSV) for table widget with a `Column Header Menu`.

`Schema Builder`

- **IMPORTANT** : 8.5.0 is changing how colliding names and (string) keys are handled when loading a schema.
  Please **review carefully** the [document](user_guide/migrating_iccube/8_4_14_to_8_5_0.md) before migrating your
  production environment.

- JDBC datasource: introduced support for AWS Athena (as a generic JDBC source - the driver JAR is not packaged
  with icCube).

`XMLA`

- Excel : add support for [Import](./user_guide/integration/excel.md) query.

- Excel : add default drillthrough action for [calc. member](./user_guide/integration/excel.md) as an
  `Additional Actions` in pivot tables.

- Excel : add support for `Additional Actions` in pivot tables : [create action](./mdx/language.md).

- Power BI : add support for [Import](./user_guide/integration/power_bi.md) query.

- Microsoft Report Builder : [supported](./user_guide/integration/report_builder.md).

- SQL Server Management Studio : partially [supported](./user_guide/integration/ssms.md).

- Tableau : [supported](./user_guide/integration/tableau.md) via Analysis Services connection.

- Fix Excel drillthrough regression (was missing prefix) and support for multi-axis query.

- Fix Excel usage of VisualTotals in sets when selecting members.

- Fix Analysis Services AdomdClient connection.

`MDX`

- New function [Expand](mdx/Expand.md).

- `DRILLTHROUGH` statement : added support for `[Dimension].NAME` and `[Dimension].KEY` notation in `RETURN` clause.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#850).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.14 : [details](user_guide/migrating_iccube/8_4_14_to_8_5_0.md).

<hr/>

### 8.4.14

<hr/>

`Server`

- Schema Permissions : fix the behavior for `+/-tuples C ...` statements and non-indexing dimensions introduced
  in `8.4.10` : the cells of the `all` member were possibly not filtered. Plus, the sign of the ignored non-indexing
  lines must be the same as the first applied line. [Contact us](https://www.iccube.com/contact-us/) for more details.

`Alert`

- Added the possibility to export [widget data](../server/user_guide/using/schema_alerts.md#widget-data-export)
  (XLSX, CSV). Requires both a server and a dashboard app. v8.4.14.

- Fix missing available schema(s) when schema(s) deployed as backup only.

`Scheduler`

- The schedule error status is taking into account the status of the last load (was ignored).

- A schedule stopped on error might be re-activated after a successful load.

`Schema`

- The behavior of an incremental load on error has been improved : see the migration document for
  more [details](user_guide/migrating_iccube/8_4_13_to_8_4_14.md).

`Schema Builder`

- ETL Views/Transformations : browse does not limit the number of rows anymore of the underlying table
  and the cached tables.

- ETL Views/Transformations : fix for concurrent browsing (was possibly corrupting the definition cache).

- ETL Views/Transformations : fix editor for several types of field when defined in plugins.

- Removed the column `primaryKey` field from `.icc-schema` file (keeping source control happy). You might want
  to re-save the definition to generate the new definition if the file is kept in source control.

- Facts/dimensions links order not changed when saving of the `.icc-schema` file (keeping source control happy).
  You might want to re-save the definition to generate the new definition if the file is kept in source control.

- Encrypted datasource credentials not changed when saving of the `.icc-schema` file (keeping source control happy).

- MongoDB : fix array decoding (was taking former value if null instead of empty array).

`XMLA`

- Added support for [SeekTable](user_guide/integration/seekTable.md) (online pivot tables).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#8414).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.13 : [details](user_guide/migrating_iccube/8_4_13_to_8_4_14.md).

<hr/>

### 8.4.13

<hr/>

`Server`

- On top of Java system properties, you can use environment variables (e.g., `${env:API_KEY}`) in the configuration
  file `icCube.xml`.

- Rest API : added the [ListSchemas](api/ListSchemas.md) request.

- Rest API : added the `flat` parameter for the [TidyExecuteMdxScript](api/TidyExecuteMdxScript.md) request.

`Alert`

- Added page orientation (portrait vs. landscape) when printing a dashboard.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#8413).

`Libraries`

- Upgraded several libraries to their latest version.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.12 : [details](user_guide/migrating_iccube/8_4_12_to_8_4_13.md).

<hr/>

### 8.4.12

<hr/>

`Server`

- Schema Permissions : support for `CONST` (and `CACHED=true`) functions.

- Schema Permissions : fix evaluation context caching introduced in 8.4.10. This cache can be switched off using the
  `schemaPermissionsCacheOff` configuration in the file `icCube.xml`.

- Fix the `PASSTHROUGH` filter for URLs without extra. path-info (was `NPE` exception).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#8412).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.11 : [details](user_guide/migrating_iccube/8_4_11_to_8_4_12.md).

<hr/>

### 8.4.11

<hr/>

`Server`

- Audit : the UI allows for accessing/downloading the generated files.

`Schema Builder`

- Facts : fixed regression introduced in 8.4.10 with the fix for unbounded queue that could potentially
  break the RAM with temporary data.

- Fix indexing by range an empty dimension with an unknown member (NPE exception).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#8411).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.10 : [details](user_guide/migrating_iccube/8_4_10_to_8_4_11.md).

<hr/>

### 8.4.10

<hr/>

`General`

- **IMPORTANT** : Do not use the icCube server v8.4.10 containing a regression when loading the facts. Used instead
  v8.4.11 that is fixing this regression.

- **IMPORTANT** : Java 21 (LTS) is being required to run icCube.

`Server`

- Schema Permissions : performance improvement when using large `SubCubeXyz` function in several `+/-tuples` statements.

- Schema Permissions : **important** change behavior for `+/-tuples C ...` statements : non-indexing dimensions
  are ignored. This can be reverted using the `nonMappedPermissionsOff` configuration in the file `icCube.xml`.

`Schema Builder`

- JDBC datasource: introduced Trino (formerly PrestoSQL) support.

- Introduced the advanced configuration property : `Localization Fallback Locale`.

- ETL : keep column's order in union transformations.

- ETL : fixed missing hash for Java code transformations (forcing to recompile them when restoring backup).

- Facts : fixed unbounded queue that could potentially break the RAM with temporary data.

`MDX`

- Fix tidy post-processing serialization : steps before the last step were not serialized.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#8410).

`AnalyticsOps`

- Introduced the project [ic3-analytics-ops](https://github.com/ic3-software/ic3-analytics-ops)
  to establish the accuracy and reliability of analytics and dashboards through Analytics governance.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.9 : [details](user_guide/migrating_iccube/8_4_9_to_8_4_10.md).

<hr/>

### 8.4.9

<hr/>

`Server`

- Auto-cancel MDX processing based on Dashboards request timeout configuration.

- On-the-fly authorization : made the `$$header$$` search and replace case-insensitive.

`Schema Builder`

- Add `LAST` aggregation to the `GroupBy` transformation (aka. ETL).

- JDBC datasources : removed `autocommit=false` (contact us if you need revert the change).

- Fix backup error when creating dynamic hierarchies (`ArrayIndexOutOfBoundsException`).

- Fix data error when creating dynamic hierarchies : null keys + Unicode chars.

`MDX`

- Add `dayOfWeek()`, `dayOfMonth()`, `dayOfYear()`, `hourOfDay()` functions to date & datetime scalar types.

- Add  `filterNulls()`, `firstNotNull()`, `lastNotNull()` to `OlapComparableVectorEntity` (returned when using Vector
  aggregations on strings) and update [documentation](../server/mdx_types/vector.md).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#849).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.8 : [details](user_guide/migrating_iccube/8_4_8_to_8_4_9.md).

<hr/>

### 8.4.8

<hr/>

`Server`

- Added icCube version to schema backups (inside the `valid.icc-marker` file).

- Renjin plugin not shipped anymore. Please [contact us](https://www.iccube.com/contact-us/) for more details.

`MDX`

- MDX results are serialized to file (instead of RAM). See the `resultSerializationConfiguration` section in
  the file `icCube.xml`. More details can be found in the [migration](user_guide/migrating_iccube/8_4_7_to_8_4_8.md)
  document as well.

- Fix possible blocking set evaluation when evaluating concurrently the same sets with different authorization profiles.

- Fix result cache replay on incr. load (latest `"json"` format was ignored).

`Schema Builder`

- Improve JDBC Additional URL Properties editor.

- Fix the 502 error dialog : redirect instead to the request status page.

- Fix possibly empty discovered tables when the schema is an empty string instead of null.

- Fix missing column names escaping for PostgreSQL discovered data tables.

- Fix data error when creating dynamic hierarchies.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#848).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.7 : [details](user_guide/migrating_iccube/8_4_7_to_8_4_8.md).

<hr/>

### 8.4.7

<hr/>

`Server`

- Fix schema backup when using dynamic hierarchies.

- Fix load schema colors and localizations when using views and parallel load.

- Fix schema builder potentially blocked when cancelling a Redshift query (browse, analyse).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#847).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.6 : [details](user_guide/migrating_iccube/8_4_6_to_8_4_7.md).

<hr/>

### 8.4.6

<hr/>

`Server`

- Print : Chrome/Chromium headless started with `--headless=new` option.

- Print : introduced margins in paper sizes definitions (see `icCube.xml`).

- Permissions: added the wildcard `*` for the `FOREACH HIERARCHY ` statement in
  the [schema permissions](user_guide/security/schema_permissions.md).

- Fix Docs permissions when defined from Role definition for dashboards applications and gadgets.

- Fix Docs permissions : file-system-root is visible from administrator and Docs. administrator only.

- Fix MDX IDE permissions : was unnecessarily requiring access to the loaded schemas.

`Schema Builder`

- Introduced reverse links in facts for improved MDX performance
  (non-empty crossjoins). The feature is not activated by default : it must be switched on in each schema.

`MDX`

- Introduced `tidyCellCountNE` (see `icCube.xml`) for dashboard queries with more than one NON EMPTY axes.

- Fix exception in NON EMPTY crossjoin with attributes in special scenario.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#846).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.5 : [details](user_guide/migrating_iccube/8_4_5_to_8_4_6.md).

<hr/>

### 8.4.5

<hr/>

`Schema Builder`

- Tables / Views : introduced `Delete Non-Used Tables` and `Delete Non-Used Views` and `Used By` information.

- Tables : allows for `Data Source` navigation in the list of tables.

- Delete Table : ensure that the table is not used by either the `Localization` or `Colors` or `Bridges` use cases.

- [Java native functions](mdx_integration/java_integration.md) : introduced the possibility to define their return type.

`Documentation`

- Introduced a [Memory Usage](../devops/MemoryUsage.md) section in the DevOps section for everything related
  to the RAM usage in the icCube server.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#845).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.4 : [details](user_guide/migrating_iccube/8_4_4_to_8_4_5.md).

<hr/>

### 8.4.4

<hr/>

`General`

- **IMPORTANT** : 8.4.4 is a maintenance release of 8.4.3. If you're migrating from an earlier version please review
  carefully the migration [document](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

`Server`

- Rest API : the [DocsListGizmos](api/DocsListGizmos.md) request has been improved to support recursive list.

- Print : fix for large dashboard state (was : 400 Bad Request).

`MDX`

- Introduced tidy post-processing for performing additional calculations on the MDX result. The first available
  post-processor is : [multiple linear regression](post_processing/MultipleLinearRegression.md).

- The [FILTERBY](mdx/FilterBy.md) clauses are accepting the SubCube functions (e.g., `SubCubeUnion`, etc...).

- When the second parameter of the [LookupByKey](mdx/LookupByKey.md) function is a measure or a calculated measure,
  it is evaluated. The use of `Value()` is no longer needed.

- Improved NON EMPTY crossjoins : up to 2x faster.

`Schema Builder`

- JDBC datasource : allows for defining several configuration fields using Java system properties and/or environment
  variables. More details can be found [here](user_guide/schemas_cubes/ds_database.md#environment-variables).

- Semantic Layer / Measures : UI improvement to delete a multi-selection of items.

- Fix issue in Column to Row transformation when inverse selection is selected.

- [Java native functions](mdx_integration/java_integration.md) : fix for declaration of multiple functions. The `DROP`
  statement allows for dropping a single native function. Introduced `static import` for referencing a native function
  from within a native function.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#844).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.3 : [details](user_guide/migrating_iccube/8_4_3_to_8_4_4.md).

<hr/>

### 8.4.3

<hr/>

`General`

- **IMPORTANT** : 8.4.3 is a maintenance release of 8.4.2. If you're migrating from an earlier version please review
  carefully the migration [document](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

`MDX`

- New function: [VectorS()](mdx/VectorS.md).

`Schema Builder`

- Add 'Member Name if no Association' field in level definition. For non-base hierarchies, when no member is associated
  with a base member, it creates a member that can be the unknown member. This member has no key.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#843).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.2 : [details](user_guide/migrating_iccube/8_4_2_to_8_4_3.md).

<hr/>

### 8.4.2

<hr/>

`General`

- **IMPORTANT** : 8.4.2 is a maintenance release of 8.4.1. If you're migrating from an earlier version please review
  carefully the migration [document](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

- Both the server and dashboards help are sharing the same look.

`Server`

- Permissions: introduced the `-all` statement in the [schema permissions](user_guide/security/schema_permissions.md).

- Fix broken import schema backup @Windows.

- Fix session-less passthrough filter for REST API call causing an `IllegalStateException`.

- Fix file system access when using Azure storage w/ Azure Container Apps.

`MDX`

- Fix `NullPointerException` for empty facts.

`Schema Builder`

- With a schema settings it's possible to allow member names defined with space characters only.

- Google BigQuery : fix `NullPointerException` when creating a new datasource (wizard).

- JDBC datasources : the password is not mandatory anymore (e.g., SQLServer Managed Identity, Postgres user without
  any password, etc...).

- SQLServer datasource : support for Managed Identity (w/ Linux native library).

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#842).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.1 : [details](user_guide/migrating_iccube/8_4_1_to_8_4_2.md).

<hr/>

### 8.4.1

<hr/>

`General`

- **IMPORTANT** : 8.4.1 is a maintenance release of 8.4.0. If you're migrating from an earlier version please review
  carefully the migration [document](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

`Schema Builder`

- Script: improve calculated measures validation to check for missing cube name in their names
  (required when the schema contains more than one cube) .

- Fix: an unexpected error when some of the underlying tables of a view used for schema localization/colors
  are used for dimensions/facts building later.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#841).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.4.0 : [details](user_guide/migrating_iccube/8_4_0_to_8_4_1.md).

<hr/>

### 8.4.0

<hr/>

`General`

- **IMPORTANT** : Review carefully the migration [document](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

- **IMPORTANT** : Java 17 (LTS) is being required to run icCube.

- **IMPORTANT** : ETL: Javascript views are not supported anymore. Please use the similar Java view instead.

- **IMPORTANT** : The password hashing algorithm has been updated. You can regenerate your passwords used for email
  notifications, the schema definition passwords will be automatically updated on first schema save.

- **IMPORTANT** : Docs: the layout of the Dashboards app. in the `/ic3-reporting` folder has been changed; upon
  startup icCube is migrating existing deployed applications and backups.

- **IMPORTANT** : Docs: the externals hosting of the Dashboards app. has been removed. Please contact us
  if you were using it.

- **IMPORTANT** : Docs: the DB repository is not supported anymore. Please contact us if you were using it. Note
  that the current file system repository is being improved for shared usage.

- **IMPORTANT** : Audit: add tenant information when the multi-tenant option is activated.

- **IMPORTANT** : MultiTenant: the tenants directory has been split into two separate directories. Check carefully
  the migration document for more information about the required steps before starting icCube.

- **IMPORTANT** : Roles/Users: very old format (pre-2018) are not migrated anymore. Please contact us if you were
  using this old format.

- **IMPORTANT** : Scheduler: very old format is not migrated anymore on startup. Please contact us if you were using
  this old format.

`Server`

- It is possible to share the `icCube-data` directory between different icCube server instances :
  [www](user_guide/running_iccube/shared_data_directory.md).

- Schemas authorization language ([www](user_guide/security/schema_permissions.md)) :  added support for
  `CREATE SET / FUNCTION` for advanced MDX expressions. The `+tuples D` statement allows for using tuples
  (vs members only).

- Rest API : ability to impersonate a tenant (see the iTenant parameter).

- Audit : fix missing opened report audit (Dashboards v8.x).

- Loggers : the admin. logger levels use case does not persist anymore the overridden levels.
  You can still manually edit your own Log4J XML configuration file.

`MDX`

- Fix set order issue when using a tail/head like function after a NonEmpty function in a subselect.

- Introduced `tidyMaterializedAxisTupleCount` configuration in MDX evaluation profiles (see `icCube.xml`)
  to limit the size of the set generated on the axes of `SELECT` statements.

- Introduced `materializedSetTupleCount` configuration in MDX evaluation profiles (see `icCube.xml`) to limit
  the actual size of the sets created via `CREATE/WITH SET` statements.

- It is possible to have trees of category members. Previous versions were deleting the children.

- New function: [LookupByKeys](mdx/LookupByKeys.md)().

- New function: [ListScalars](mdx/ListScalars.md)().

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#840).

`Libraries`

- Upgraded several libraries to their latest version.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.3.0 : [details](user_guide/migrating_iccube/8_3_0_to_8_4_0.md).

<hr/>

### 8.3.0

<hr/>

`General`

- **IMPORTANT** : The format of the reports/dashboards (Dashboards v8) saved in the Docs has been changed. icCube
  is migrating the `Docs` repository but please check and read carefully the migrating
  [document](user_guide/migrating_iccube/8_2_2_to_8_3_0.md).

`Server`

- Authorization : a role can define (and override) the Docs permissions : more details
  [here](user_guide/security/docs_permissions.md)

- On-The-Fly Authorization : the header service has been extended to support the Dashboards and Docs tabs of the
  role definition. On top of that, the MDX-role header allows for defining the name of the role used to select the
  MDX execution profile.

- FORM login : removed the redirect. Please [contact us](https://www.iccube.com/contact-us/) if you need it.

- Rest API : [ExecuteMdxScript](api/ExecuteMdxScript.md) has been deprecated in favor of
  [TidyExecuteMdxScript](api/TidyExecuteMdxScript.md) which is more robust. Note that `ExecuteMdxScript` will be
  removed in a future version of icCube. Until that, if you still need it, you can define the `icCubeProperties`
  `rest.api.ExecuteMdxScript.deprecated` in the file `icCube.xml`.

- Rest API: [DiscoverSchema](api/DiscoverSchema.md) : introduced for discovering the content (e.g.,, dimensions,
  measures, etc...) of a loaded schema.

`MDX`

- MDX queries sent by the Dashboards application are generating natively tidy tables.

- Introduced `tidyRowCount`|`tidyColumnCount`|`tidyCellCount` configurations in MDX evaluation profiles
  (see `icCube.xml`). Those values are controlling the size of the tidy table generated for the MDX queries
  sent by the Dashboards application.

- Caption definition allows for localization (e.g., `CAPTION="Good Morning\\fr:Bonjour\\es:Hola"`).

- New function: [EvalEntity()](mdx/EvalEntity.md).

- Fix potential livelock with set evaluations.

`Schema Builder`

- Time Dimension Wizard : fix when using the table for the end data and the underlying dimension has a leaf member
  of months, quarters or years.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#830).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.2.2 : [details](user_guide/migrating_iccube/8_2_2_to_8_3_0.md).

<hr/>

### 8.2.2

<hr/>

`Server`

- Print server : removed deprecated `wkhtmltopdf` support: only Chrome/Chromium is supported.

`MDX`

- Fix `members` function on levels for first level (not all) for dimensions with a ragged structures
  (`[Geo].[Continent].members`).

`Schema Builder`

- Fix secondary hierarchies in the Time Wizard with `Time Divisions` on minutes and seconds.

- Add string to date conversion for JDBC data sources (advanced tab) : handy for SQLite.

- Relax constraint to allow linking dates fact values to a time dimension with seconds (time will be set to 0:0:0).

- Fix sorting transformations when using an underlying table with a set of selected columns.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#822).

`Libraries`

- Upgraded CDP4J to 6.0.0

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.2.1 : [details](user_guide/migrating_iccube/8_2_1_to_8_2_2.md).

<hr/>

### 8.2.1

<hr/>

`MDX`

- Performance: improve auto-exist with large sub-select (aka. `filterby`) sets.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#821).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.2.0 : [details](user_guide/migrating_iccube/8_2_0_to_8_2_1.md).

<hr/>

### 8.2.0

<hr/>

`General`

- **IMPORTANT** : Please check the new default value for the `icCube.nonEmptyBehaviorSetupMode` property in the file
  `icCube.xml`.

`Server`

- Configuration : on top of environment variables, icCube is first attempting to use Java system properties to locate
  configuration files : `icCube.license.file` (file: `icCube-4.lic`), `icCube.configuration.file` (file: `icCube.xml`),
  `icCube.log4j.configuration.file` (file: `log4j.xml`). You might refer to this page for more details :
  ([www](user_guide/configuring_iccube/configuring_iccube.md)).

- Roles: introduced Dashboards permissions for enabling/disabling actions in the Dashboards application
  (`editor`): more details ([here](user_guide/security/dashboards_permissions.md)).

- Access Rights: give access to the `Admin` console for role with `Docs.` only privileges.

- Access Rights: fix denied access to Dashboards (Docs) home directory for non administrator users.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#820).

`Schema Builder`

- Member attributes have been introduced ([www](mdx/Member%20Attributes.md)) to quickly define secondary hierarchies
  and improve auto-exist performance. This allows for a kind of tabular view of the base hierarchy.

- Hierarchies defined as member attributes allow to solve `currentMember` if the base member is defined.

- Member properties are now inherited : i.e., properties defined in parent levels will be accessible from their
  descendants.

- SPSS data source : fix starting 0 on compressed version.

`MDX`

- `NON_EMPTY_BEHAVIOR` : the value of the property `icCube.nonEmptyBehaviorSetupMode` (`icCube.xml`) has been
  switched to `AUTO` (from `MANUAL`). This property is controlling how the calculated member `NON_EMPTY_BEHAVIOR`
  is calculated. Please [contact us](https://www.iccube.com/contact-us/) if you have any issue with weird non-empty
  processing.

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.1.1 : [details](user_guide/migrating_iccube/8_1_1_to_8_2_0.md).

<hr/>

### 8.1.1

<hr/>

`MDX`

- New [UserLocale()](mdx/UserLocale.md) and [UserLanguage()](mdx/UserLanguage.md) functions.

- Functions [dtNextQuarter()](mdx/dtNextQuarter.md) and [dtPreviousQuarter()](mdx/dtPreviousQuarter.md) do not raise
  an error on quarters.

- Fix possibly deadlock with calculated member and sets during cell evaluation.

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#811).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.1 : [details](user_guide/migrating_iccube/8_0_1_to_8_1_1.md).

<hr/>

### 8.0.1

<hr/>

`Dashboards`

- You can check the following [document](../dashboards/ReleaseNotes.md#810).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.0 : [details](user_guide/migrating_iccube/8_0_0_to_8_0_1.md).

<hr/>

### 8.0.0

<hr/>

`General`

- **IMPORTANT** :  Backups are broken. If you still want to use existing backups switch on the property
  `singleMeasureDimensionalityOff` in `icCube.xml`.

- **IMPORTANT** : A Docs administrator can access the `[Docs:File System]` in write mode.

- **IMPORTANT** : Log4j has been migrated to Log4j 2: please convert your `log4j.xml` file to the new format
  or replace it with the one provided in this kit.

`Server`

- The `Header Authentication Service` (and `Passthrough Filter`): ensure session's principal consistency.

`MDX`

- For none indexing dimension, it is possible to add calculated members to the last level (creating a new level).

- Fix: do not cache MDX result when cancelled waiting for run ticket.

- Fix: order function on multi-column keys (key property returns an `OlapComparableVectorEntity`).

- Fix: accept `@{}` in code completion.

`Schema Builder`

- MySQL/mariaDB datasource: fix date/datetime columns (was `Unknown partial converter`... error).

- MySQL/mariaDB datasource: fix table/column names with spaces (was missing ``).

- SPSS datasource: early support for a datasource based on a SPSS (sav) file.

`Dashboards`

- First official release with the new Reporting application called Dashboards. Both applications can be enabled
  on the server (Dashboards only being the default). Check the `report.viz.enabled`/`report.v8.enabled` properties
  to enable/disable those applications (see `icCube.xml`).

`Libraries`

- Upgraded PostgreSQL JDBC driver to version 42.3.3

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.0-rc.4 : [details](user_guide/migrating_iccube/8_0_0_rc_4_to_8_0_0.md).

<hr/>

### 8.0.0-rc.4

<hr/>

`General`

- **IMPORTANT** : Backups are broken. If you still want to use existing backups switch on the property
  `singleMeasureDimensionalityOff` in `icCube.xml`.

- **IMPORTANT** : A Docs administrator can access the `[Docs:File System]` in write mode.

- **IMPORTANT** : Log4j has been migrated to Log4j 2: please convert your `log4j.xml` file to the new format
  or replace it with the one provided in this kit.

`MDX`

- New strict operators: `==`, `!=`, `>>`, `>>=`, `<<`, `<<=` ([www](mdx/Operators.md)).

`Dashboards`

- First official release with the new Reporting application called Dashboards. Both applications can be enabled
  on the server (Dashboards only being the default). Check the `report.viz.enabled`/`report.v8.enabled` properties
  to enable/disable those applications (see `icCube.xml`).

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.0-rc.3 : [details](user_guide/migrating_iccube/8_0_0_rc_3_to_8_0_0_rc_4.md).

<hr/>

### 8.0.0-rc.3

<hr/>

`General`

- **IMPORTANT** : Backups are broken. If you still want to use existing backups switch on the property
  `singleMeasureDimensionalityOff` in `icCube.xml`.

- **IMPORTANT** : A Docs administrator can access the `[Docs:File System]` in write mode.

- **IMPORTANT** : Log4j has been migrated to Log4j 2: please convert your `log4j.xml` file to the new format
  or replace it with the one provided in this kit.

`Server`

- Existing JCR repository not migrated anymore.

- Printing: fix `NullPointerException` exception with `printToPDF` + introduce `readingTimeoutMS` property
  in `icCube.xml`.

`MDX`

- Filter function: add a limit parameter ([www](mdx/Filter.md)).

- Potentially improve processing time of `function( set-expression, lambda-expression ).head( N )`;
  e.g., `filter()`, `nonEmpty()`, etc...

- New function: [PatternMatchesStartsWith()](mdx/PatternMatchesStartsWith.md).

- New function: [PatternMatchesEndsWith()](mdx/PatternMatchesEndsWith.md).

- New function: [PatternMatchesContains()](mdx/PatternMatchesContains.md).

- New function: [PatternMatchesEquals()](mdx/PatternMatchesEquals.md).

`Schema Builder`

- JDBC datasource: introduced a playground console to quickly execute any SQL statement.

`Dashboards`

- First official release with the new Reporting application called Dashboards. Both applications can be enabled
  on the server (Dashboards only being the default). Check the `report.viz.enabled`/`report.v8.enabled` properties
  to enable/disable those applications (see `icCube.xml`).

`Libraries`

- Upgraded Jetty to version 9.4.44

- Upgraded Log4j to version 2.17.1 (from 1.2.15)

- Upgraded Commons BeanUtils to version 1.9.4

- Upgraded Commons Compress to version 1.21

- Upgraded Commons IO to version 2.11.0

- Upgraded GSON to version 2.8.9

- Upgraded Guava to version 31.0.1

- Upgraded Quartz to version 2.3.2

- Upgraded Xerces to version 2.12.1

- Upgraded HTTP Client to version 4.5.13

- Upgraded OWASP HTML Sanitizer to version 20211018.2

- Upgraded PostgreSQL JDBC driver to version 42.3.1

- Upgraded MySQL JDBC driver to version 8.0.27

- Upgraded SQL Server JDBC driver to version 9.4.1

- Upgraded JAVA Mail to version 1.6.2

- Upgraded Javassist to version 3.28.0-GA

- Refresh Jetbrains Annotations version 16.0.3 (fix MD5)

- Refresh jTDS JDBC driver version 1.3.1 (fix MD5)

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.0-rc.2 : [details](user_guide/migrating_iccube/8_0_0_rc_2_to_8_0_0_rc_3.md).

<hr/>

### 8.0.0-rc.2

<hr/>

`General`

- **IMPORTANT** : Backups are broken. If you still want to use existing backups switch on
  the property `singleMeasureDimensionalityOff` in `icCube.xml`.

- **IMPORTANT** : A Docs administrator can access the `[Docs:File System]` in write mode.

`Server`

- Fix incorrect type mismatch error on strings with min/max aggregation.

`Schema Builder`

- Excel datasource are using the `No Cell Formulas` flag as default.

- Fix Excel datasource flag: `No Cell Formulas` (was missing header row containing the column names).

`MDX`

- The [RGB](mdx/RGB.md) function with one parameter returns `NULL` on `null/empty` parameter value: `RGB(NULL) = NULL`.

`Dashboards`

- First official release with the new Reporting application called Dashboards. Both applications can be enabled
  on the server (Dashboards only being the default). Check the `report.viz.enabled`/`report.v8.enabled` properties
  to enable/disable those applications (see `icCube.xml`).

`Libraries`

- Upgraded LZ4 to 1.8.0

- Upgraded CDP4J to 5.4.0

`Others`

- Several enhancements and bug fixes.

- Migrating from 8.0.0-rc.1 : [details](user_guide/migrating_iccube/8_0_0_rc_1_to_8_0_0_rc_2.md).

<hr/>

### 8.0.0-rc.1

<hr/>

`General`

- **IMPORTANT** : Backups are broken. If you still want to use existing backups switch on
  the property `singleMeasureDimensionalityOff` in `icCube.xml`.

- **IMPORTANT** : A Docs administrator can access the `[Docs:File System]` in write mode.

`Server`

- Fix `CREATE SESSION MEMBER` (e.g., Excel) : was creating calculated members globally.

`Dashboards`

- First official release with the new Reporting application called Dashboards. Both applications can be enabled
  on the server (Dashboards only being the default). Check the `report.viz.enabled`/`report.v8.enabled` properties
  to enable/disable those applications (see `icCube.xml`).

`Others`

- Several enhancements and bug fixes.

- Migrating from 7.12 : [details](user_guide/migrating_iccube/7_12_to_8_0_0_rc_1.md).

<hr/>

### Earlier Versions

<hr/>

Please [contact us](https://www.iccube.com/contact-us/) if you need information about earlier versions.

_
